/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.moka.fuml.library.LibraryExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;

public class LibraryRegistry {
    protected static final String LIBRARY_CLASS = "libraryFactoryClass";
    protected static final String LIBRARY_URI = "libraryURI";
    protected static final String MOKA_ENGINE_LIBRARY_EXTENSION_POINT_ID = "org.eclipse.papyrus.moka.fuml.library";
    protected List<LibraryExecutionFactory> libraryFactory = new ArrayList<LibraryExecutionFactory>();
    private static LibraryRegistry INSTANCE;

    private LibraryRegistry() {
    }

    public static LibraryRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryRegistry();
        }
        return INSTANCE;
    }

    public void loadLibraryFactories(ResourceSet resourceSet) {
        if (resourceSet != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurations = registry.getConfigurationElementsFor(MOKA_ENGINE_LIBRARY_EXTENSION_POINT_ID);
            int i = 0;
            while (i < configurations.length) {
                Resource libraryResource;
                URI libraryURI = null;
                Object factory = null;
                try {
                    libraryURI = URI.createURI((String)configurations[i].getAttribute(LIBRARY_URI));
                    factory = configurations[i].createExecutableExtension(LIBRARY_CLASS);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (factory != null && libraryURI != null && !libraryURI.isEmpty() && (libraryResource = resourceSet.getResource(libraryURI, true)) != null) {
                    ((LibraryExecutionFactory)factory).parseLibrary(libraryURI, libraryResource);
                    this.libraryFactory.add((LibraryExecutionFactory)factory);
                }
                ++i;
            }
        }
    }

    public void installLibraries(ILocus locus) {
        for (LibraryExecutionFactory factory : this.libraryFactory) {
            factory.installFunctions(locus);
        }
        for (LibraryExecutionFactory factory : this.libraryFactory) {
            factory.installServices(locus);
        }
    }
}

