/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.simpleclassifiers;

import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IIntegerValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.PrimitiveValue;
import org.eclipse.papyrus.moka.fuml.values.Value;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class IntegerValue
extends PrimitiveValue
implements IIntegerValue {
    public Integer value;

    public Object getUnderlying() {
        return this.value;
    }

    @Override
    public ValueSpecification specify() {
        LiteralInteger literal = UMLFactory.eINSTANCE.createLiteralInteger();
        literal.setType((Type)this.type);
        literal.setValue(this.value.intValue());
        return literal;
    }

    @Override
    public Boolean equals(IValue otherValue) {
        boolean isEqual = false;
        if (otherValue instanceof IntegerValue) {
            isEqual = ((IntegerValue)otherValue).value.equals(this.value);
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        IntegerValue newValue = (IntegerValue)super.copy();
        newValue.value = this.value;
        return newValue;
    }

    @Override
    public Value new_() {
        return new IntegerValue();
    }

    @Override
    public String toString() {
        String stringValue = "";
        if (this.value == 0) {
            stringValue = "0";
        } else {
            int positiveValue = this.value;
            if (positiveValue < 0) {
                positiveValue = -positiveValue;
            }
            do {
                int digit;
                if ((digit = positiveValue % 10) == 0) {
                    stringValue = "0" + stringValue;
                    continue;
                }
                if (digit == 1) {
                    stringValue = "1" + stringValue;
                    continue;
                }
                if (digit == 2) {
                    stringValue = "2" + stringValue;
                    continue;
                }
                if (digit == 3) {
                    stringValue = "3" + stringValue;
                    continue;
                }
                if (digit == 4) {
                    stringValue = "4" + stringValue;
                    continue;
                }
                if (digit == 5) {
                    stringValue = "5" + stringValue;
                    continue;
                }
                if (digit == 6) {
                    stringValue = "6" + stringValue;
                    continue;
                }
                if (digit == 7) {
                    stringValue = "7" + stringValue;
                    continue;
                }
                if (digit == 8) {
                    stringValue = "8" + stringValue;
                    continue;
                }
                if (digit != 9) continue;
                stringValue = "9" + stringValue;
            } while ((positiveValue /= 10) > 0);
            if (this.value < 0) {
                stringValue = "-" + stringValue;
            }
        }
        return stringValue;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }
}

