/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.debug.core.DebugException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.service.DebugServiceClient;
import org.eclipse.papyrus.moka.debug.service.IDebugService;
import org.eclipse.papyrus.moka.kernel.process.MQTTServerConfig;
import org.eclipse.papyrus.moka.kernel.service.ExecutionEngineService;

public abstract class DebugService<T, C>
extends ExecutionEngineService<IDebuggableExecutionEngine<T, C>>
implements IDebugService<T, C> {
    protected DebugServiceClient client;
    protected boolean enginSuspendRequest;
    protected ReentrantLock engineSuspendRequestLock;
    protected boolean engineTerminateRequest;
    protected ReentrantLock engineTerminateRequestLock;
    protected Map<String, Boolean> threadSuspendRequest;
    protected ReentrantLock threadSuspendRequestLock;
    protected List<String> threadTerminateRequest;
    protected ReentrantLock threadTerminateRequestLock;
    protected ReentrantLock engineLock;
    protected Condition engineExecutionCondition;

    public void init(IDebuggableExecutionEngine<T, C> engine) {
        super.init(engine);
        this.engineLock = new ReentrantLock(true);
        this.engineExecutionCondition = this.engineLock.newCondition();
        this.enginSuspendRequest = false;
        this.engineSuspendRequestLock = new ReentrantLock(true);
        this.engineTerminateRequest = false;
        this.engineTerminateRequestLock = new ReentrantLock();
        this.threadSuspendRequest = new HashMap<String, Boolean>();
        this.threadSuspendRequestLock = new ReentrantLock(true);
        this.threadTerminateRequest = new ArrayList<String>();
        this.threadTerminateRequestLock = new ReentrantLock(true);
        this.initClient();
        this.initDebugAssistant();
    }

    private void initClient() {
        String port = MQTTServerConfig.getMQTTServerPort();
        this.client = new DebugServiceClient("tcp://localhost:" + port, "Debug Service Client", this);
        this.client.run();
    }

    protected abstract void initDebugAssistant();

    protected boolean shouldEngineSuspend() {
        boolean flag = false;
        this.engineSuspendRequestLock.lock();
        flag = this.enginSuspendRequest;
        this.engineSuspendRequestLock.unlock();
        return flag;
    }

    protected boolean shouldEngineTerminate() {
        boolean flag = false;
        this.engineTerminateRequestLock.lock();
        flag = this.engineTerminateRequest;
        this.engineTerminateRequestLock.unlock();
        return flag;
    }

    public void dispose(IDebuggableExecutionEngine<T, C> engine) {
        this.client.terminate();
        if (this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (MqttException e) {
                e.printStackTrace();
            }
        }
        this.client = null;
    }

    @Override
    public boolean requestSuspendEngine() {
        this.engineSuspendRequestLock.lock();
        this.enginSuspendRequest = true;
        this.engineSuspendRequestLock.unlock();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void suspendEngine() {
        block25: {
            if (((IDebuggableExecutionEngine)this.engine).canSuspend()) {
                this.engineSuspendRequestLock.lock();
                this.enginSuspendRequest = false;
                this.engineSuspendRequestLock.unlock();
                if (((IDebuggableExecutionEngine)this.engine).canSuspend()) {
                    block21: {
                        try {
                            try {
                                ((IDebuggableExecutionEngine)this.engine).suspend();
                                break block21;
                            }
                            catch (DebugException e) {
                                e.printStackTrace();
                                this.engineLock.lock();
                                ** while (((IDebuggableExecutionEngine)this.engine).isSuspended())
                            }
                        }
                        catch (Throwable var2_8) {
                            this.engineLock.lock();
                            ** while (((IDebuggableExecutionEngine)this.engine).isSuspended())
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                try {
                                    this.engineExecutionCondition.await();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    this.engineLock.unlock();
                                    continue;
                                }
                            }
                            catch (Throwable var4_5) {
                                this.engineLock.unlock();
                                throw var4_5;
                            }
                            this.engineLock.unlock();
                            continue;
                        }
lbl28:
                        // 1 sources

                        this.engineLock.unlock();
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                try {
                                    this.engineExecutionCondition.await();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    this.engineLock.unlock();
                                    continue;
                                }
                            }
                            catch (Throwable var4_6) {
                                this.engineLock.unlock();
                                throw var4_6;
                            }
                            this.engineLock.unlock();
                            continue;
                        }
lbl47:
                        // 1 sources

                        this.engineLock.unlock();
                        throw var2_8;
                    }
                    this.engineLock.lock();
                    while (((IDebuggableExecutionEngine)this.engine).isSuspended()) {
                        try {
                            try {
                                this.engineExecutionCondition.await();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                this.engineLock.unlock();
                                continue;
                            }
                        }
                        catch (Throwable var4_7) {
                            this.engineLock.unlock();
                            throw var4_7;
                        }
                        this.engineLock.unlock();
                    }
                    this.engineLock.unlock();
                }
            }
        }
    }

    @Override
    public boolean requestResumeEngine() {
        if (((IDebuggableExecutionEngine)this.engine).canResume()) {
            try {
                try {
                    ((IDebuggableExecutionEngine)this.engine).resume();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    this.engineLock.lock();
                    this.engineExecutionCondition.signalAll();
                    this.engineLock.unlock();
                }
            }
            finally {
                this.engineLock.lock();
                this.engineExecutionCondition.signalAll();
                this.engineLock.unlock();
            }
        }
        return false;
    }

    @Override
    public boolean requestTerminateEngine() {
        this.engineTerminateRequestLock.lock();
        this.engineTerminateRequest = true;
        this.engineTerminateRequestLock.unlock();
        if (((IDebuggableExecutionEngine)this.engine).isSuspended()) {
            this.requestResumeEngine();
        }
        return true;
    }

    @Override
    public void terminateEngine() {
        if (((IDebuggableExecutionEngine)this.engine).canTerminate()) {
            this.engineTerminateRequestLock.lock();
            this.engineTerminateRequest = false;
            this.engineTerminateRequestLock.unlock();
            try {
                ((IDebuggableExecutionEngine)this.engine).terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean requestSuspendThread(String identifier) {
        this.threadSuspendRequestLock.lock();
        this.threadSuspendRequest.put(identifier, true);
        this.threadSuspendRequestLock.unlock();
        return true;
    }

    @Override
    public void suspendThread(IDebuggableExecutionEngineThread<T, C> thread) {
        ((IDebuggableExecutionEngine)this.engine).suspendThread(thread);
        if (((IDebuggableExecutionEngine)this.engine).canSuspend()) {
            this.engineLock.lock();
            try {
                try {
                    this.engineExecutionCondition.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.engineLock.unlock();
                }
            }
            finally {
                this.engineLock.unlock();
            }
        }
    }

    @Override
    public boolean requestResumeThread(String identifier) {
        boolean resumed = false;
        IDebuggableExecutionEngineThread thread = ((IDebuggableExecutionEngine)this.engine).getThread(identifier);
        if (thread != null) {
            boolean shouldEngineResume = false;
            ((IDebuggableExecutionEngine)this.engine).resumeThread(thread);
            this.threadSuspendRequestLock.lock();
            this.threadSuspendRequest.put(thread.getID(), false);
            shouldEngineResume = DebugService.shouldEngineResume(this.threadSuspendRequest);
            this.threadSuspendRequestLock.unlock();
            resumed = true;
            if (shouldEngineResume) {
                this.engineLock.lock();
                this.engineExecutionCondition.signalAll();
                this.engineLock.unlock();
            }
        }
        return resumed;
    }

    private static boolean shouldEngineResume(Map<String, Boolean> suspendRequest) {
        return suspendRequest.entrySet().stream().noneMatch(e -> (Boolean)e.getValue());
    }

    @Override
    public boolean requestTerminateThread(String identifier) {
        boolean added = false;
        this.threadTerminateRequestLock.lock();
        if (!this.threadTerminateRequest.contains(identifier)) {
            added = this.threadTerminateRequest.add(identifier);
        }
        this.threadTerminateRequestLock.unlock();
        return added;
    }

    @Override
    public void terminateThread(IDebuggableExecutionEngineThread<T, C> thread) {
        this.threadTerminateRequestLock.lock();
        if (this.threadTerminateRequest.contains(thread.getID())) {
            this.threadTerminateRequest.remove(thread.getID());
        }
        this.threadTerminateRequestLock.unlock();
        ((IDebuggableExecutionEngine)this.engine).terminateThread(thread);
    }

    @Override
    public void fireTerminateEngineEvent() {
        this.client.fireTerminateEngineEvent();
    }
}

