/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.target;

import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.papyrus.moka.debug.communication.MessagesReader;
import org.eclipse.papyrus.moka.debug.messages.DebugRequest;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTarget;

public class ExecutionEngineDebugTargetClientListener
implements IMqttMessageListener {
    protected IExecutionEngineDebugTarget debugTarget;

    public ExecutionEngineDebugTargetClientListener(IExecutionEngineDebugTarget target) {
        assert (target != null);
        this.debugTarget = target;
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        block10: {
            block11: {
                if (this.debugTarget == null) break block10;
                if (!topic.equals("debug-service/thread")) break block11;
                ThreadRequest request = MessagesReader.getThreadRequest(message);
                switch (request.getEventKind()) {
                    case 2: {
                        ExecutionEngineThread thread = this.debugTarget.getThread(request.getThreadId());
                        if (thread != null) {
                            thread.setSuspensionReason(request.getSuspensionReason());
                            thread.handleSuspendEvent(request.getEventDetail());
                            break;
                        }
                        break block10;
                    }
                    case 4: {
                        this.debugTarget.handleTargetThreadCreateEvent(request);
                        break;
                    }
                    case 8: {
                        this.debugTarget.handleTargetThreadTerminateEvent(request);
                    }
                }
                break block10;
            }
            if (topic.equals("debug-service/engine")) {
                DebugRequest request = MessagesReader.getDebugRequest(message);
                switch (request.getEventKind()) {
                    case 8: {
                        this.debugTarget.handleTargetTerminateEvent();
                    }
                }
            }
        }
    }
}

