/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.pssm.commonbehavior.EventTriggeredExecution;
import org.eclipse.papyrus.moka.pssm.commonbehavior.ISM_ObjectActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.CompletionEventOccurrence;
import org.eclipse.papyrus.moka.pssm.statemachines.DeferredEventOccurrence;
import org.eclipse.papyrus.moka.pssm.statemachines.DoActivityContextObject;
import org.eclipse.papyrus.moka.pssm.statemachines.EntryPointPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.ForkPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IHistoryPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IPseudostateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IVertexActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.RegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMachineExecution;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMachineSemanticVisitor;
import org.eclipse.papyrus.moka.pssm.statemachines.StateMetadata;
import org.eclipse.papyrus.moka.pssm.statemachines.VertexActivation;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class StateActivation
extends VertexActivation
implements IStateActivation {
    protected List<IRegionActivation> regionActivation = new ArrayList<IRegionActivation>();
    protected List<IPseudostateActivation> connectionPointActivation = new ArrayList<IPseudostateActivation>();
    public boolean isEntryCompleted = false;
    public boolean isDoActivityCompleted = false;
    public boolean isExitCompleted;
    public DoActivityContextObject doActivityContextObject;

    public void setEntryCompletion(boolean completed) {
        this.isEntryCompleted = completed;
    }

    public void setExitCompletion(boolean completed) {
        this.isExitCompleted = completed;
    }

    public void setDoActivityCompletion(boolean completed) {
        this.isDoActivityCompleted = completed;
    }

    public boolean hasCompleted() {
        boolean stateCompleted = this.isEntryCompleted & this.isDoActivityCompleted;
        int i = 0;
        while (stateCompleted && i < this.regionActivation.size()) {
            stateCompleted = stateCompleted && this.regionActivation.get(i).isCompleted();
            ++i;
        }
        return stateCompleted;
    }

    public void complete() {
        CompletionEventOccurrence completionEventOccurrence = new CompletionEventOccurrence();
        completionEventOccurrence.register(this);
    }

    public List<IPseudostateActivation> getConnectionPointActivation() {
        return this.connectionPointActivation;
    }

    public IPseudostateActivation getConnectionPointActivation(Vertex vertex) {
        IPseudostateActivation activation = null;
        int i = 0;
        while (i < this.connectionPointActivation.size() && activation == null) {
            if (this.connectionPointActivation.get(i).getNode() == vertex) {
                activation = this.connectionPointActivation.get(i);
            }
            ++i;
        }
        return activation;
    }

    @Override
    public boolean isVisitorFor(NamedElement node) {
        boolean isVisitor = super.isVisitorFor(node);
        if (!isVisitor) {
            State state = ((State)this.node).getRedefinedState();
            while (!isVisitor && state != null) {
                if (state == node) {
                    isVisitor = true;
                    continue;
                }
                state = state.getRedefinedState();
            }
        }
        return isVisitor;
    }

    @Override
    public IVertexActivation getVertexActivation(Vertex vertex) {
        IPseudostateActivation vertexActivation = null;
        State state = (State)this.getNode();
        if (state.isComposite() && (vertexActivation = this.getConnectionPointActivation(vertex)) == null) {
            int i = 0;
            while (i < this.regionActivation.size() && vertexActivation == null) {
                vertexActivation = this.regionActivation.get(i).getVertexActivation(vertex);
                ++i;
            }
        }
        return vertexActivation;
    }

    public List<IRegionActivation> getRegionActivation() {
        return this.regionActivation;
    }

    @Override
    public void activate() {
        State state = (State)this.getNode();
        if (state.isComposite()) {
            Object activation;
            IObject_ context = this.getExecutionContext();
            for (Pseudostate connectionPoint : state.getConnectionPoints()) {
                activation = (IPseudostateActivation)context.getLocus().getFactory().instantiateVisitor((Element)connectionPoint);
                activation.setParent((ISemanticVisitor)this);
                activation.setNode((NamedElement)connectionPoint);
                this.connectionPointActivation.add((IPseudostateActivation)activation);
            }
            for (Region region : state.getRegions()) {
                activation = (RegionActivation)context.getLocus().getFactory().instantiateVisitor((Element)region);
                ((StateMachineSemanticVisitor)((Object)activation)).setParent((ISemanticVisitor)this);
                ((StateMachineSemanticVisitor)((Object)activation)).setNode((NamedElement)region);
                ((RegionActivation)((Object)activation)).activate();
                this.regionActivation.add((IRegionActivation)activation);
            }
        }
    }

    @Override
    public void activateTransitions() {
        State state = (State)this.getNode();
        if (state.isComposite()) {
            for (IRegionActivation activation : this.regionActivation) {
                activation.activateTransitions();
            }
        }
    }

    public Behavior getEntry() {
        State state = (State)this.getNode();
        Behavior entry = state.getEntry();
        while (entry == null && state.getRedefinedState() != null) {
            state = state.getRedefinedState();
            entry = state.getEntry();
        }
        return entry;
    }

    public Behavior getExit() {
        State state = (State)this.getNode();
        Behavior exit = state.getExit();
        while (exit == null && state.getRedefinedState() != null) {
            state = state.getRedefinedState();
            exit = state.getExit();
        }
        return exit;
    }

    public Behavior getDoActivity() {
        State state = (State)this.getNode();
        Behavior doActivity = state.getDoActivity();
        while (doActivity == null && state.getRedefinedState() != null) {
            state = state.getRedefinedState();
            doActivity = state.getDoActivity();
        }
        return doActivity;
    }

    public void tryExecuteEntry(IEventOccurrence eventOccurrence) {
        Behavior entry;
        if (!this.isEntryCompleted && (entry = this.getEntry()) != null) {
            IExecution execution = this.getExecutionFor(entry, eventOccurrence);
            if (execution != null) {
                execution.execute();
                this.isEntryCompleted = true;
            }
            if (this.hasCompleted()) {
                this.complete();
            }
        }
    }

    public void tryInvokeDoActivity(IEventOccurrence eventOccurrence) {
        Behavior doActivity;
        if (!this.isDoActivityCompleted && (doActivity = this.getDoActivity()) != null) {
            this.doActivityContextObject = new DoActivityContextObject();
            this.getExecutionLocus().add((IExtensionalValue)this.doActivityContextObject);
            this.doActivityContextObject.initialize(this.getExecutionContext());
            this.doActivityContextObject.owner = this;
            ArrayList inputs = null;
            IExecution doActivityExecution = this.getExecutionFor(doActivity, eventOccurrence);
            if (doActivityExecution instanceof EventTriggeredExecution) {
                ((EventTriggeredExecution)doActivityExecution).initialize();
                inputs = new ArrayList(((EventTriggeredExecution)doActivityExecution).wrappedExecution.getParameterValues());
            }
            this.doActivityContextObject.startBehavior((Class)doActivity, inputs);
        }
    }

    public void tryExecuteExit(IEventOccurrence eventOccurrence) {
        IExecution execution;
        Behavior exit = this.getExit();
        if (exit != null && (execution = this.getExecutionFor(exit, eventOccurrence)) != null) {
            execution.execute();
        }
        super.exit(null, eventOccurrence, null);
    }

    public void enterRegions(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence) {
        ArrayList<Vertex> targetedVertices = new ArrayList<Vertex>();
        IVertexActivation sourceActivation = enteringTransition.getSourceActivation();
        if (sourceActivation instanceof ForkPseudostateActivation) {
            Pseudostate fork = (Pseudostate)sourceActivation.getNode();
            int i = 0;
            while (i < fork.getOutgoings().size()) {
                targetedVertices.add(((Transition)fork.getOutgoings().get(i)).getTarget());
                ++i;
            }
        } else {
            IVertexActivation targetActivation = enteringTransition.getTargetActivation();
            if (targetActivation instanceof EntryPointPseudostateActivation) {
                Pseudostate entryPoint = (Pseudostate)targetActivation.getNode();
                int i = 0;
                while (i < entryPoint.getOutgoings().size()) {
                    targetedVertices.add(((Transition)entryPoint.getOutgoings().get(i)).getTarget());
                    ++i;
                }
            } else if (!(targetActivation instanceof IHistoryPseudostateActivation)) {
                targetedVertices.add((Vertex)targetActivation.getNode());
            }
        }
        int i = 0;
        while (i < this.regionActivation.size()) {
            IRegionActivation regionActivation = this.regionActivation.get(i);
            int j = 0;
            boolean found = false;
            while (j < targetedVertices.size() && !found) {
                found = regionActivation.getVertexActivation((Vertex)targetedVertices.get(j)) != null;
                ++j;
            }
            if (!found) {
                regionActivation.enter(enteringTransition, eventOccurrence);
            }
            ++i;
        }
    }

    @Override
    public boolean isEnterable(ITransitionActivation enteringTransition, boolean staticCheck) {
        return !((StateMachineExecution)this.getStateMachineExecution()).getConfiguration().isActive((IVertexActivation)this);
    }

    @Override
    public boolean canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        boolean propagate = true;
        if (!this.regionActivation.contains(leastCommonAncestor)) {
            propagate = super.canPropagateExecution(enteringTransition, eventOccurrence, leastCommonAncestor);
        }
        if (propagate && this.regionActivation.size() > 0) {
            int i = 0;
            while (propagate && i < this.regionActivation.size()) {
                propagate = this.regionActivation.get(i).canPropagateExecution(eventOccurrence, enteringTransition);
                ++i;
            }
        }
        return propagate;
    }

    @Override
    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        if (this.status.equals((Object)StateMetadata.IDLE)) {
            super.enter(enteringTransition, eventOccurrence, leastCommonAncestor);
            this.isEntryCompleted = this.getEntry() == null;
            this.isDoActivityCompleted = this.getDoActivity() == null;
            this.isExitCompleted = this.getExit() == null;
            StateMachineExecution smExecution = (StateMachineExecution)this.getStateMachineExecution();
            smExecution.getConfiguration().register((IStateActivation)this);
            if (this.hasCompleted()) {
                this.complete();
            } else {
                this.tryExecuteEntry(eventOccurrence);
                this.tryInvokeDoActivity(eventOccurrence);
                this.enterRegions(enteringTransition, eventOccurrence);
            }
        }
    }

    @Override
    public boolean isExitable(ITransitionActivation exitingTransition, boolean staticCheck) {
        return !this.isEnterable(exitingTransition, staticCheck);
    }

    @Override
    public void exit(ITransitionActivation exitingTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        if (!this.regionActivation.isEmpty()) {
            for (IRegionActivation regionActivation : this.regionActivation) {
                regionActivation.exit(exitingTransition, eventOccurrence);
            }
        }
        if (!this.isDoActivityCompleted) {
            this.doActivityContextObject.destroy();
            this.doActivityContextObject = null;
        }
        if (!this.isExitCompleted) {
            this.tryExecuteExit(eventOccurrence);
        }
        this.isEntryCompleted = false;
        this.isDoActivityCompleted = false;
        this.isExitCompleted = false;
        IRegionActivation containgRegionActivation = this.getOwningRegionActivation();
        containgRegionActivation.setHistory((IStateActivation)this);
        StateMachineExecution smExecution = (StateMachineExecution)this.getStateMachineExecution();
        smExecution.getConfiguration().unregister((IStateActivation)this);
        super.exit(exitingTransition, eventOccurrence, leastCommonAncestor);
    }

    public List<ITransitionActivation> getFireableTransitions(IEventOccurrence eventOccurrence) {
        ArrayList<ITransitionActivation> fireableTransitions = new ArrayList<ITransitionActivation>();
        int i = 0;
        while (i < this.outgoingTransitionActivations.size()) {
            ITransitionActivation outgoingTransitionActivation = (ITransitionActivation)this.outgoingTransitionActivations.get(i);
            if (outgoingTransitionActivation.canFireOn(eventOccurrence)) {
                fireableTransitions.add(outgoingTransitionActivation);
            }
            ++i;
        }
        return fireableTransitions;
    }

    public boolean canDefer(IEventOccurrence eventOccurrence) {
        State state = (State)this.node;
        boolean deferred = eventOccurrence.matchAny((List)state.getDeferrableTriggers());
        while (!deferred && state.getRedefinedState() != null) {
            state = state.getRedefinedState();
            deferred = eventOccurrence.matchAny((List)state.getDeferrableTriggers());
        }
        if (deferred) {
            int i = 0;
            ITransitionActivation overridingTransitionActivation = null;
            while (overridingTransitionActivation == null && i < this.outgoingTransitionActivations.size()) {
                ITransitionActivation currentTransitionActivation = (ITransitionActivation)this.outgoingTransitionActivations.get(i);
                if (currentTransitionActivation.canFireOn(eventOccurrence)) {
                    overridingTransitionActivation = currentTransitionActivation;
                }
                ++i;
            }
            deferred = overridingTransitionActivation == null;
        }
        return deferred;
    }

    public void defer(IEventOccurrence eventOccurrence) {
        DeferredEventOccurrence deferringEventOccurrence = new DeferredEventOccurrence();
        deferringEventOccurrence.setDeferredEventOccurrence(eventOccurrence);
        deferringEventOccurrence.register(this);
    }

    public void releaseDeferredEvents() {
        IObject_ context = this.getExecutionContext();
        if (context.getObjectActivation() != null) {
            ((ISM_ObjectActivation)context.getObjectActivation()).releaseDeferredEvents((IStateActivation)this);
        }
    }

    @Override
    public void terminate() {
        if (this.isActive()) {
            if (!this.regionActivation.isEmpty()) {
                int i = 0;
                while (i < this.regionActivation.size()) {
                    this.regionActivation.get(i).terminate();
                    ++i;
                }
                this.regionActivation.clear();
            }
            if (!this.isDoActivityCompleted) {
                this.doActivityContextObject.destroy();
            }
            this.connectionPointActivation.clear();
        }
    }
}

