/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.trace.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.ISemanticVisitorExecutionListener;
import org.eclipse.papyrus.moka.kernel.assistant.Suspension;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.service.ExecutionEngineService;
import org.eclipse.papyrus.moka.trace.Activator;
import org.eclipse.papyrus.moka.trace.capture.CaptureServiceRegistry;
import org.eclipse.papyrus.moka.trace.formater.TraceFileFormaterRegistry;
import org.eclipse.papyrus.moka.trace.interfaces.capture.ICaptureServiceFactory;
import org.eclipse.papyrus.moka.trace.interfaces.capture.ITraceCaptureService;
import org.eclipse.papyrus.moka.trace.interfaces.format.ITraceFileFormater;
import org.eclipse.papyrus.moka.trace.model.mokatraceservice.MokaTrace;
import org.eclipse.papyrus.moka.tracepoint.service.MarkerUtils;

public class TraceGenerationService
extends ExecutionEngineService<IExecutionEngine>
implements ISemanticVisitorExecutionListener {
    public static final String FILE_NAME = "trace";
    protected ICaptureServiceFactory captureServiceFactory;
    protected List<ITraceFileFormater> formaters;
    protected String traceDirectory;
    protected MokaTrace trace;
    protected boolean isTraceServiceActivate = false;
    protected boolean tracepointMode = false;
    protected Set<EObject> tracepoints;

    public void init(IExecutionEngine engine) {
        super.init(engine);
        EngineConfiguration configuration = engine.getConfiguration();
        if (configuration != null && configuration.isTraceEnabled()) {
            this.isTraceServiceActivate = configuration.isTraceEnabled();
            this.formaters = Collections.singletonList(TraceFileFormaterRegistry.INSTANCE.getFormaterFromID(configuration.getFormatterID()));
            this.traceDirectory = configuration.getTraceFilePath();
            this.captureServiceFactory = CaptureServiceRegistry.INSTANCE.getCaptureService(this.formaters.iterator().next().getCaptureId());
            this.trace = this.captureServiceFactory.createTraceElement();
            this.captureServiceFactory.startTraceElement(this.trace);
            this.tracepointMode = configuration.isTracepointMode();
            this.initTracePoint(configuration.getExecutionSource());
        }
    }

    protected void initTracePoint(EObject modelElement) {
        this.tracepoints = new HashSet<EObject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            if (root != null) {
                IMarker[] tracePoints;
                IMarker[] iMarkerArray = tracePoints = root.findMarkers("org.eclipse.papyrus.tracepointmarker", true, 2);
                int n = tracePoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker tracePointObj = iMarkerArray[n2];
                    if (tracePointObj instanceof IMarker) {
                        IMarker tracePoint = tracePointObj;
                        ResourceSet resourceSet = modelElement.eResource().getResourceSet();
                        EObject eobj = MarkerUtils.getEObjectOfMarker((ResourceSet)resourceSet, (IMarker)tracePoint);
                        this.tracepoints.add(eobj);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logger.error("Error occured while finding markers for " + root, (Throwable)e);
        }
    }

    public void dispose(IExecutionEngine engine) {
        super.dispose(engine);
        if (this.isTraceServiceActivate) {
            for (ITraceFileFormater formater : this.formaters) {
                String path = this.getDirectoryPath(formater);
                formater.rightTrace(path, (Object)this.trace);
            }
        }
    }

    private String getDirectoryPath(ITraceFileFormater formater) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        String workspacePath = workspace.getLocation().toFile().getPath().toString();
        IFile currentFile = null;
        try {
            currentFile = workspace.getFileForLocation((IPath)new Path(String.valueOf(workspacePath) + this.traceDirectory));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (currentFile != null) {
            return String.valueOf(workspacePath) + this.traceDirectory;
        }
        IContainer currentFolder = null;
        try {
            currentFolder = workspace.getContainerForLocation((IPath)new Path(String.valueOf(workspacePath) + this.traceDirectory));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (currentFolder != null && currentFolder.exists()) {
            return String.valueOf(workspacePath) + this.traceDirectory;
        }
        return this.traceDirectory;
    }

    public void nodeVisited(ISemanticVisitor nodeVisitor) {
        ITraceCaptureService tracer;
        if (this.shouldTrace(nodeVisitor) && (tracer = this.captureServiceFactory.getCaptureService(nodeVisitor)) != null) {
            tracer.traceBeforeNode(nodeVisitor, this.trace);
        }
    }

    public void nodeLeft(ISemanticVisitor nodeVisitor) {
        ITraceCaptureService tracer;
        if (this.shouldTrace(nodeVisitor) && (tracer = this.captureServiceFactory.getCaptureService(nodeVisitor)) != null) {
            tracer.traceAfterNode(nodeVisitor, this.trace);
        }
    }

    protected boolean shouldTrace(ISemanticVisitor nodeVisitor) {
        return this.isTraceServiceActivate && (this.tracepointMode && this.captureServiceFactory.isVisitorConcernedByTracepoints(this.tracepoints, nodeVisitor) || !this.tracepointMode);
    }

    public void nodeSuspended(ISemanticVisitor visitor, Suspension suspension) {
    }
}

