/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.tracepoint.service;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.moka.tracepoint.service.Activator;
import org.eclipse.papyrus.moka.tracepoint.service.ITraceMechanism;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;

public class TraceMechanism {
    public static final String ITRACE_MECHANISM_ID = "org.eclipse.papyrus.moka.tracepoint.service.traceMechanism";

    public static List<ITraceMechanism> getTraceMechanisms() {
        IConfigurationElement[] configElements;
        BasicEList mechanisms = new BasicEList();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(ITRACE_MECHANISM_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj = configElement.createExecutableExtension("class");
                if (obj instanceof ITraceMechanism) {
                    mechanisms.add((Object)((ITraceMechanism)obj));
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return mechanisms;
    }

    public static String getMechanismFromPreferences(TraceActions.TraceFeature feature) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store != null) {
            if (feature == TraceActions.TraceFeature.Class) {
                return String.valueOf(TraceActions.getStringPrefix(TraceActions.TraceFeature.Port)) + store.getInt("papyrus.trace.implementation.port") + "," + TraceActions.getStringPrefix(TraceActions.TraceFeature.State) + store.getInt("papyrus.trace.implementation.sm") + "," + TraceActions.getStringPrefix(TraceActions.TraceFeature.Operation) + store.getInt("papyrus.trace.implementation.op");
            }
            if (feature == TraceActions.TraceFeature.State) {
                return store.getString("papyrus.trace.implementation.sm");
            }
            if (feature == TraceActions.TraceFeature.Operation) {
                return store.getString("papyrus.trace.implementation.op");
            }
        }
        return "";
    }

    public static String getDefaultMechanism(EObject element) {
        return TraceMechanism.getMechanismFromPreferences(TraceActions.getTraceFeature(element));
    }
}

