/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.rotative;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.rotative.RotativeImageHelper;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class RotativeImageFigure
extends WorkspaceImageFigure {
    private String imagePath;
    private int orientation;

    public RotativeImageFigure(String imagePath) {
        super(RotativeImageFigure.flyWeightImage((String)imagePath));
        this.imagePath = imagePath;
        this.orientation = 1;
    }

    public void refreshFigure(CustomStyle imageStyle) {
        String imgPath = RotativeImageHelper.getInstance().getImagePath(imageStyle);
        if (imgPath != null && !imgPath.equals(this.imagePath)) {
            this.imagePath = imgPath;
        }
        this.refreshFigure();
    }

    private void refreshFigure() {
        this.setImage(this.getImage(this.imagePath, this.orientation));
        this.repaint();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.refreshFigure();
    }

    private Image getImage(String path, int direction) {
        String key = this.getKey(path, direction);
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            image = direction == 1 ? RotativeImageFigure.flyWeightImage((String)path) : this.rotate(this.getImage(path, 1), direction);
            registry.put(key, image);
        }
        return image;
    }

    private String getKey(String path, int direction) {
        return String.valueOf(path) + direction;
    }

    private Image rotate(Image image, int direction) {
        if (image == null) {
            return null;
        }
        ImageData srcData = image.getImageData();
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        byte[] newData = new byte[srcData.data.length];
        boolean isAlpha = srcData.alphaData != null;
        byte[] newAlphaData = null;
        int destBytesPerLine = 0;
        ImageData imgData = null;
        switch (direction) {
            case 8: 
            case 16: {
                destBytesPerLine = srcData.height * bytesPerPixel;
                imgData = new ImageData(srcData.height, srcData.width, srcData.depth, srcData.palette, destBytesPerLine, newData);
                break;
            }
            default: {
                destBytesPerLine = srcData.width * bytesPerPixel;
                imgData = new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
            }
        }
        if (isAlpha) {
            newAlphaData = new byte[srcData.alphaData.length];
            imgData.alphaData = newAlphaData;
        }
        imgData.alpha = srcData.alpha;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX;
                int destY = switch (direction) {
                    case 8 -> {
                        destX = srcY;
                        yield srcData.width - srcX - 1;
                    }
                    case 16 -> {
                        destX = srcData.height - srcY - 1;
                        yield srcX;
                    }
                    case 4 -> {
                        destX = srcData.width - srcX - 1;
                        yield srcData.height - srcY - 1;
                    }
                    default -> {
                        destX = srcX;
                        yield srcY;
                    }
                };
                imgData.setPixel(destX, destY, srcData.getPixel(srcX, srcY));
                if (isAlpha) {
                    imgData.setAlpha(destX, destY, srcData.getAlpha(srcX, srcY));
                }
                ++srcX;
            }
            ++srcY;
        }
        return new Image(image.getDevice(), imgData);
    }
}

