/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.profile.robotics.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FunctionKind implements Enumerator
{
    ON_CONFIGURE(0, "ON_CONFIGURE", "ON_CONFIGURE"),
    ON_ACTIVATE(1, "ON_ACTIVATE", "ON_ACTIVATE"),
    ON_DEACTIVATE(2, "ON_DEACTIVATE", "ON_DEACTIVATE"),
    ON_CLEANUP(3, "ON_CLEANUP", "ON_CLEANUP"),
    ON_ERROR(4, "ON_ERROR", "ON_ERROR"),
    HANDLER(5, "HANDLER", "HANDLER"),
    PERIODIC(6, "PERIODIC", "PERIODIC"),
    MANUALLY_CALLED(7, "MANUALLY_CALLED", "MANUALLY_CALLED");

    public static final int ON_CONFIGURE_VALUE = 0;
    public static final int ON_ACTIVATE_VALUE = 1;
    public static final int ON_DEACTIVATE_VALUE = 2;
    public static final int ON_CLEANUP_VALUE = 3;
    public static final int ON_ERROR_VALUE = 4;
    public static final int HANDLER_VALUE = 5;
    public static final int PERIODIC_VALUE = 6;
    public static final int MANUALLY_CALLED_VALUE = 7;
    private static final FunctionKind[] VALUES_ARRAY;
    public static final List<FunctionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FunctionKind[]{ON_CONFIGURE, ON_ACTIVATE, ON_DEACTIVATE, ON_CLEANUP, ON_ERROR, HANDLER, PERIODIC, MANUALLY_CALLED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FunctionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FunctionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FunctionKind get(int value) {
        switch (value) {
            case 0: {
                return ON_CONFIGURE;
            }
            case 1: {
                return ON_ACTIVATE;
            }
            case 2: {
                return ON_DEACTIVATE;
            }
            case 3: {
                return ON_CLEANUP;
            }
            case 4: {
                return ON_ERROR;
            }
            case 5: {
                return HANDLER;
            }
            case 6: {
                return PERIODIC;
            }
            case 7: {
                return MANUALLY_CALLED;
            }
        }
        return null;
    }

    private FunctionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

