/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.utils;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageProjectSupport;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppClassUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.transformation.base.utils.ProjectManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.component.RoboticsCppCreator;
import org.eclipse.papyrus.robotics.ros2.codegen.handlers.RewriteCDTHandler;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2PreferenceUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ProjectTools {
    public static IProject getProject(String projectName) {
        try {
            IProject genProject = ProjectManagement.getNamedProject((String)projectName);
            if (genProject != null && genProject.exists() && genProject.getNature("org.eclipse.cdt.core.ccnature") == null || RewriteCDTHandler.rewriteProject(projectName)) {
                genProject = null;
            }
            if (genProject == null || !genProject.exists()) {
                ILangProjectSupport projectSupport = LanguageProjectSupport.getProjectSupport((String)"C++");
                String currentIndexer = CCorePlugin.getIndexManager().getDefaultIndexerId();
                IIndexManager _indexManager = CCorePlugin.getIndexManager();
                _indexManager.setDefaultIndexerId("org.eclipse.cdt.core.nullindexer");
                genProject = projectSupport.createProject(projectName, TransformationContext.current.modelRoot);
                IIndexManager _indexManager_1 = CCorePlugin.getIndexManager();
                _indexManager_1.setDefaultIndexerId(currentIndexer);
                if (genProject != null && !genProject.exists()) {
                    String _format = String.format("project does not exist", new Object[0]);
                    throw new RuntimeException(_format);
                }
                if (genProject != null) {
                    ProjectTools.configureCDT(genProject, projectName.toLowerCase());
                } else {
                    throw new TransformationException(ExecuteTransformationChain.USER_CANCEL);
                }
            }
            return genProject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void configureCDT(IProject project, String pkgName) {
        try {
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription cdesc = mngr.getProjectDescription(project, true);
            try {
                ICConfigurationDescription[] _configurations;
                String _get = EnvironmentUtils.get((String)"AMENT_PREFIX_PATH");
                EnvironmentVariable amentPrefix = new EnvironmentVariable("AMENT_PREFIX_PATH", _get);
                String _get_1 = EnvironmentUtils.get((String)"CMAKE_PREFIX_PATH");
                EnvironmentVariable cmakePrefix = new EnvironmentVariable("CMAKE_PREFIX_PATH", _get_1);
                String _get_2 = EnvironmentUtils.get((String)"PYTHONPATH");
                EnvironmentVariable pythonPath = new EnvironmentVariable("PYTHONPATH", _get_2);
                ICConfigurationDescription[] iCConfigurationDescriptionArray = _configurations = cdesc.getConfigurations();
                int n = _configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription configDescr = iCConfigurationDescriptionArray[n2];
                    IContributedEnvironment contribEnv = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
                    contribEnv.addVariable((IEnvironmentVariable)amentPrefix, configDescr);
                    contribEnv.addVariable((IEnvironmentVariable)cmakePrefix, configDescr);
                    contribEnv.addVariable((IEnvironmentVariable)pythonPath, configDescr);
                    IConfiguration main = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescr);
                    main.setBuildCommand("colcon");
                    IBuilder builder = main.getBuilder();
                    builder.setUseDefaultBuildCmd(false);
                    builder.setBuildPath("${workspace_loc:}");
                    String buildCmd = String.format("build %s %s %s", Ros2PreferenceUtils.getColconOptions(), Ros2PreferenceUtils.getColconPackageOptions(), pkgName);
                    String _name = configDescr.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)"Debug");
                    if (_equals) {
                        String _buildCmd = buildCmd;
                        buildCmd = String.valueOf(_buildCmd) + " --cmake-args  -DCMAKE_BUILD_TYPE=Debug";
                    }
                    builder.setBuildAttribute("org.eclipse.cdt.make.core.build.target.inc", buildCmd);
                    main.setManagedBuildOn(false);
                    ++n2;
                }
                mngr.setProjectDescription(project, cdesc, true, null);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                TransformationContext.monitor.subTask("waiting for CDT to finish project setup");
                ProjectTools.waitForCDT();
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException ce = (CoreException)_t;
                    String _message = ce.getMessage();
                    throw new RuntimeException(_message);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void waitForCDT() {
        boolean _not;
        boolean _isIndexerIdle = CCorePlugin.getIndexManager().isIndexerIdle();
        boolean bl = _not = !_isIndexerIdle;
        if (_not) {
            TransformationContext.monitor.subTask("waiting for CDT indexer");
            int i = 0;
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable _t) {
                    if (_t instanceof InterruptedException) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            } while (!CCorePlugin.getIndexManager().isIndexerIdle() && ++i < 100);
        }
    }

    public static boolean configureIncludes(IProject project, List<String> depPkgList) {
        boolean _xblockexpression = false;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription cdesc = mngr.getProjectDescription(project, true);
        boolean _xifexpression = false;
        if (cdesc != null) {
            boolean _xtrycatchfinallyexpression = false;
            try {
                ICConfigurationDescription[] _configurations;
                boolean _xblockexpression_1 = false;
                ICConfigurationDescription[] iCConfigurationDescriptionArray = _configurations = cdesc.getConfigurations();
                int n = _configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    ICConfigurationDescription configDescr = iCConfigurationDescriptionArray[n2];
                    ICFolderDescription folderDescription = configDescr.getRootFolderDescription();
                    ICLanguageSetting[] languageSettings = folderDescription.getLanguageSettings();
                    ArrayList<CIncludePathEntry> icIncludePaths = new ArrayList<CIncludePathEntry>();
                    CIncludePathEntry _cIncludePathEntry = new CIncludePathEntry("${workspace_loc:/${ProjName}/src-gen}", 0);
                    icIncludePaths.add(_cIncludePathEntry);
                    String amentPrefixPath = EnvironmentUtils.get((String)"AMENT_PREFIX_PATH");
                    if (amentPrefixPath != null) {
                        String[] _split;
                        String[] stringArray = _split = amentPrefixPath.split(":");
                        int n4 = _split.length;
                        n3 = 0;
                        while (n3 < n4) {
                            String amentEntry = stringArray[n3];
                            String _format = String.format("%s/include", amentEntry);
                            CIncludePathEntry _cIncludePathEntry_1 = new CIncludePathEntry(_format, 0);
                            icIncludePaths.add(_cIncludePathEntry_1);
                            ++n3;
                        }
                    }
                    for (String depPkg : depPkgList) {
                        String _includePath = ProjectTools.getIncludePath(depPkg);
                        CIncludePathEntry _cIncludePathEntry_2 = new CIncludePathEntry(_includePath, 0);
                        icIncludePaths.add(_cIncludePathEntry_2);
                    }
                    ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
                    n3 = languageSettings.length;
                    int n5 = 0;
                    while (n5 < n3) {
                        String[] _sourceExtensions;
                        ICLanguageSetting lang = iCLanguageSettingArray[n5];
                        String[] stringArray = _sourceExtensions = lang.getSourceExtensions();
                        int n6 = _sourceExtensions.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String ext = stringArray[n7];
                            boolean _equals = ext.equals("cpp");
                            if (_equals) {
                                lang.setSettingEntries(1, icIncludePaths);
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n2;
                }
                mngr.setProjectDescription(project, cdesc, true, null);
                _xtrycatchfinallyexpression = _xblockexpression_1 = ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException ce = (CoreException)_t;
                    String _message = ce.getMessage();
                    throw new RuntimeException(_message);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static void genCode(RoboticsCppCreator codeGen, Class component) {
        UniqueEList packagesToGenerate = new UniqueEList();
        packagesToGenerate.add((Object)component.getNearestPackage());
        EList _includedClassifiers = CppClassUtils.includedClassifiers((Classifier)component);
        for (Classifier incCl : _includedClassifiers) {
            boolean _not;
            boolean _isApplied = StereotypeUtil.isApplied((Element)incCl, External.class);
            boolean bl = _not = !_isApplied;
            if (!_not) continue;
            packagesToGenerate.add((Object)incCl.getNearestPackage());
        }
        for (Package pkg : packagesToGenerate) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            codeGen.createPackageableElement((PackageableElement)pkg, (IProgressMonitor)_nullProgressMonitor);
        }
    }

    public static String getIncludePath(String pkgName) {
        String prefixPath = EnvironmentUtils.get((String)"AMENT_PREFIX_PATH");
        if (prefixPath != null) {
            String[] _split;
            String[] stringArray = _split = prefixPath.split(":");
            int n = _split.length;
            int n2 = 0;
            while (n2 < n) {
                String pathEntry = stringArray[n2];
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(pathEntry);
                _builder.append("/include/");
                _builder.append(pkgName);
                String testPath = _builder.toString();
                boolean _exists = new File(testPath).exists();
                if (_exists) {
                    return testPath;
                }
                ++n2;
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("${WorkspaceDirPath}/install/");
        _builder.append(pkgName);
        _builder.append("/include");
        return _builder.toString();
    }
}

