/*****************************************************************************
 * Copyright (c) 2018 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *  Matteo MORELLI      matteo.morelli@cea.fr - Bug #566899
 *
 *****************************************************************************/

package org.eclipse.papyrus.robotics.ros2.codegen.build

import org.eclipse.uml2.uml.Class
import org.eclipse.uml2.uml.Package

import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageTools.pkgName
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.PackageXMLUtils.*
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.ComponentUtils.getDependsPackage;
import static extension org.eclipse.papyrus.robotics.ros2.codegen.utils.SkillUtils.*
import java.util.List
import org.eclipse.papyrus.robotics.ros2.codegen.utils.MessageUtils
import java.util.ArrayList
import org.eclipse.papyrus.uml.tools.utils.PackageUtil

class CreateCompPackageXML {

	public static String USER = "USER"
	
	static def createPackageXML(Package model, List<Class> components, Class system) '''
		«val entities = entityArray(components, system)»
		<?xml version="1.0"?>
		<package format="3">
			<name>«model.pkgName»</name>
			<version>0.0.0</version>
			<description>«entities.description»</description>
			<maintainer email="«entities.maintainerMail»">«entities.maintainerName»</maintainer>
			<license>Apache2.0</license>
			<url type="website">https://eclipse.org/papyrus</url>
			<author email="«entities.authorMail»">«model.authorName»</author>

			<buildtool_depend>ament_cmake</buildtool_depend>

			«FOR dependency : calcDependencies(components)»
				<build_depend>«dependency»</build_depend>
			«ENDFOR»
			«IF !system.uniqueSkills.nullOrEmpty»
				<build_depend>«model.realizationPackageName»</build_depend>
			«ENDIF»

			«FOR dependency : calcDependencies(components)»
				 <exec_depend>«dependency»</exec_depend>
			«ENDFOR»
			«IF !system.uniqueSkills.nullOrEmpty»
				<exec_depend>«model.realizationPackageName»</exec_depend>
			«ENDIF»

«««			«FOR dependency : calcDependencies»
«««				 <run_depend>«dependency»</run_depend>
«««			«ENDFOR»
			<export>
				<build_type>ament_cmake</build_type>
			</export>
		</package>
	'''

	static def calcDependencies(List<Class> components) {
		val dependencies = MessageUtils.calcDependencies(components)
		for (component : components) {
			// add user-defined dependencies defined for a component package
			for (pkgName : component.dependsPackage) {
				if (!dependencies.contains(pkgName)) {
					dependencies.add(pkgName)
				}
			}
		}
		return dependencies
	}

	static def entityArray(List<Class> components, Class system) {
		val entities = new ArrayList<Package>
		if (system !== null) {
			entities.add(PackageUtil.getRootPackage(system))
		}
		for (Class component : components) {
			entities.add(PackageUtil.getRootPackage(component))
		}
		return entities
	}

	static def generate(IPFileSystemAccess fileAccess, Package pkg, List<Class> components, Class system) {
		fileAccess.generateFile("package.xml", createPackageXML(pkg, components, system).toString)
	}
}