/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OccurenceEstimation implements Enumerator
{
    _1(0, "1", "1"),
    _2(1, "2", "2"),
    _3(2, "3", "3");

    public static final int _1_VALUE = 0;
    public static final int _2_VALUE = 1;
    public static final int _3_VALUE = 2;
    private static final OccurenceEstimation[] VALUES_ARRAY;
    public static final List<OccurenceEstimation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OccurenceEstimation[]{_1, _2, _3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OccurenceEstimation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OccurenceEstimation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OccurenceEstimation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OccurenceEstimation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OccurenceEstimation get(int value) {
        switch (value) {
            case 0: {
                return _1;
            }
            case 1: {
                return _2;
            }
            case 2: {
                return _3;
            }
        }
        return null;
    }

    private OccurenceEstimation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

