/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.simplifiedui.internal;

import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;

public final class ContextConfigurator {
    public static final String[] DEFAULT_CONTEXTS = new String[]{"UML"};
    public static final String[] RMS_CONTEXTS = new String[]{"MARTE"};
    public static final ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private static boolean showDefault = true;
    private static boolean showRMS = false;

    private ContextConfigurator() {
    }

    public static void showDefault() {
        if (!showDefault) {
            ContextConfigurator.setVisibility(DEFAULT_CONTEXTS, true);
            showDefault = true;
        }
    }

    public static void hideDefault() {
        if (showDefault) {
            ContextConfigurator.setVisibility(DEFAULT_CONTEXTS, false);
            showDefault = false;
        }
    }

    public static void showRobotics() {
        if (!showRMS) {
            ContextConfigurator.setVisibility(RMS_CONTEXTS, true);
            showRMS = true;
        }
    }

    public static void hideRobotics() {
        if (showRMS) {
            ContextConfigurator.setVisibility(RMS_CONTEXTS, false);
            showRMS = false;
        }
    }

    public static void setVisibility(String[] contextNames, boolean visibility) {
        String[] stringArray = contextNames;
        int n = contextNames.length;
        int n2 = 0;
        while (n2 < n) {
            String contextName = stringArray[n2];
            org.eclipse.papyrus.infra.properties.contexts.Context context = configurationManager.getContext(contextName);
            if (context != null) {
                try {
                    if (visibility) {
                        configurationManager.enableContext(context, true);
                    } else {
                        configurationManager.disableContext(context, true);
                    }
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static interface Context {
        public static final String ADVANCE_STYLE = "AdvanceStyle";
        public static final String CSS = "CSS";
        public static final String CUSTOMIZATION = "Customization";
        public static final String NOTATION = "notation";
        public static final String STYLE = "style";
        public static final String SYNCHRONIZATION = "synchronization";
        public static final String SYMBOLS = "Symbols";
        public static final String UML_NOTATION = "UMLNotation";
        public static final String UML = "UML";
        public static final String MARTE = "MARTE";
        public static final String UML_STEREOTYPE_APPLICATION_EXTERNAL_RESOURCE = "UMLStereotypeApplicationExternalResource";
        public static final String SEQUENCE_NOTATION = "SequenceNotation";
    }
}

