/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.uml2.uml.NamedElement;

public class TrackNames<T extends NamedElement> {
    Map<String, T> lastNames = new HashMap<String, T>();
    EList<T> umlList;

    public TrackNames(EList<T> umlList) {
        this.umlList = umlList;
        for (NamedElement named : umlList) {
            if (named.getName() == null) continue;
            this.lastNames.put(named.getName(), named);
        }
    }

    public T get(String name) {
        return (T)((NamedElement)this.lastNames.get(name));
    }

    public boolean containsValue(T value) {
        return this.lastNames.containsValue(value);
    }

    public void update(List<String> nameListXt) {
        String[] stringArray = this.lastNames.keySet().toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            boolean found = false;
            for (String nameXt : nameListXt) {
                if (nameXt == null || !name.equals(nameXt)) continue;
                found = true;
                break;
            }
            if (!found) {
                for (String nameXt : nameListXt) {
                    if (nameListXt == null || nameXt == null || this.lastNames.containsKey(nameXt)) continue;
                    NamedElement existingParam = (NamedElement)this.lastNames.get(name);
                    this.lastNames.put(nameXt, existingParam);
                    break;
                }
                this.lastNames.remove(name);
            }
            ++n2;
        }
        for (String nameXt : nameListXt) {
            if (nameXt == null || this.lastNames.containsKey(nameXt)) continue;
            NamedElement existingProperty = null;
            if (this.umlList != null) {
                existingProperty = ElementUtils.getNamedElementFromList(this.umlList, (String)nameXt);
            }
            this.lastNames.put(nameXt, existingProperty);
        }
    }
}

