/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReverseParametersFromSource;
import org.eclipse.papyrus.robotics.ros2.reverse.fromfile.ReversePortsFromSource;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.FolderUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ModelTemplate;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ReverseUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class ReverseNodeFromSource {
    private static final String PACKAGE_XML = "package.xml";
    private static final String NAME_TAG = "<name>";
    private static final String NAME_TAG_END = "</name>";
    protected IFile file;
    protected boolean writeModel;

    public ReverseNodeFromSource(IFile file) {
        this.file = file;
    }

    public void reverseNode(final IProgressMonitor monitor) {
        IIndex index = null;
        try {
            try {
                IProject project;
                String name;
                String pkgName = null;
                IFile packageXML = ReverseNodeFromSource.scanPackageXML(this.file.getParent());
                if (packageXML != null) {
                    String line;
                    BufferedReader results = new BufferedReader(new InputStreamReader(packageXML.getContents()));
                    while ((line = results.readLine()) != null) {
                        if (!(line = line.trim()).startsWith(NAME_TAG)) continue;
                        pkgName = line.substring(NAME_TAG.length());
                        int idx = pkgName.indexOf(NAME_TAG_END);
                        if (idx == -1) break;
                        pkgName = pkgName.substring(0, idx);
                        break;
                    }
                }
                if ((name = this.file.getName()).endsWith(".cpp")) {
                    name = name.substring(0, name.length() - 4);
                }
                monitor.beginTask("reverse component " + name, 3);
                monitor.subTask("obtain AST");
                final ITranslationUnit itu = (ITranslationUnit)CoreModel.getDefault().create(this.file);
                ICProject cproject = CoreModel.getDefault().getCModel().getCProject(this.file.getProject().getName());
                index = CCorePlugin.getIndexManager().getIndex(cproject);
                index.acquireReadLock();
                final IASTTranslationUnit ast = itu.getAST(index, 2);
                monitor.worked(1);
                String fileName = String.valueOf(name) + ".compdef.uml";
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (pkgName == null) {
                    project = FolderUtils.obtainProject(fileName);
                    pkgName = project != null ? project.getName() : name;
                }
                project = root.getProject(pkgName);
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                if (!project.exists()) {
                    project.create((IProgressMonitor)progressMonitor);
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)progressMonitor);
                }
                IFolder fModels = FolderUtils.createFolderStructure(project);
                IFolder fComponents = FolderUtils.getComponentFolder(fModels);
                final IFile fCompModel = fComponents.getFile(fileName);
                this.writeModel = true;
                if (fCompModel.exists()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReverseNodeFromSource.this.writeModel = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Model exists already", (String)String.format("A model for the node exists already (at the default location \"%s\"). Should it be overwritten?", fCompModel));
                        }
                    });
                }
                if (this.writeModel) {
                    URI newURI = URI.createURI((String)("platform:/resource/" + pkgName + "/models/components/" + fileName));
                    ModelTemplate mt = new ModelTemplate(newURI, "compdef");
                    final NotationModel notation = mt.getNotationModel();
                    final Package pkg = mt.getUMLModel();
                    PackageUtil.loadPackage((URI)URI.createURI((String)"pathmap://ROS2_LIBRARY/ros2.primitive.uml"), (ResourceSet)pkg.eResource().getResourceSet());
                    PackageUtil.loadPackage((URI)CppUriConstants.ANSIC_LIB, (ResourceSet)pkg.eResource().getResourceSet());
                    final String nameFinal = name;
                    final String pkgNameFinal = pkgName;
                    RecordingCommand reverseComponent = new RecordingCommand(mt.getDomain()){

                        protected void doExecute() {
                            pkg.setName(pkgNameFinal);
                            Class clazz = (Class)pkg.getOwnedType("[modelNameUC]");
                            clazz.setName(nameFinal);
                            ReverseUtils.setXmlID((NamedElement)clazz);
                            try {
                                Diagram diagram = notation.getDiagram("[modelNameUC]");
                                String newName = String.valueOf(StringUtils.upperCaseFirst((String)nameFinal)) + " diagram";
                                diagram.setName(newName);
                            }
                            catch (BadArgumentExcetion | NotFoundException e) {
                                e.printStackTrace();
                            }
                            List pathMapURIs = ScanUtils.allPathmapModels((String)".servicedef.uml");
                            monitor.subTask("obtain ports");
                            new ReversePortsFromSource(clazz, pathMapURIs, itu).updatePorts((IASTNode)ast);
                            monitor.worked(1);
                            monitor.subTask("obtain parameters");
                            new ReverseParametersFromSource(clazz, ast).updateParameters();
                            monitor.worked(1);
                        }
                    };
                    mt.executeCmd((Command)reverseComponent);
                    mt.save(monitor);
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                if (index != null) {
                    index.releaseReadLock();
                }
            }
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
    }

    public static IFile scanPackageXML(IContainer folder) {
        IFile result;
        IFile candidate = folder.getFile((IPath)new Path(PACKAGE_XML));
        if (candidate != null && candidate.exists()) {
            return candidate;
        }
        if (folder.getParent() != null && (result = ReverseNodeFromSource.scanPackageXML(folder.getParent())) != null) {
            return result;
        }
        return null;
    }
}

