/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.architecture.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.robotics.bpc.profile.util.BPCResource;
import org.eclipse.papyrus.robotics.bt.architecture.Activator;
import org.eclipse.papyrus.robotics.library.util.RoboticsLibResource;
import org.eclipse.papyrus.robotics.profile.util.RoboticsResource;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateBTMLModelCommand
implements IModelCreationCommand {
    private static final String TEMPLATE_URI = "platform:/plugin/org.eclipse.papyrus.robotics.bt.architecture/templates/btmodel-template.uml";

    public void createModel(ModelSet modelSet) {
        this.runAsTransaction(modelSet);
    }

    protected void runAsTransaction(ModelSet modelSet) {
        final Resource modelResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
        URI origURI = modelResource.getURI();
        try {
            try {
                modelResource.setURI(URI.createURI((String)TEMPLATE_URI));
                modelResource.load(null);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Initialize model", Collections.EMPTY_LIST){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        EObject model = CreateBTMLModelCommand.this.getRootElement(modelResource);
                        CreateBTMLModelCommand.this.attachModelToResource(model, modelResource);
                        CreateBTMLModelCommand.this.initializeModel(model);
                        return CommandResult.newOKCommandResult();
                    }
                };
                editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                modelResource.setURI(origURI);
            }
        }
        finally {
            modelResource.setURI(origURI);
        }
    }

    protected EObject getRootElement(Resource modelResource) {
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0) {
            Object root = modelResource.getContents().get(0);
            if (root instanceof EObject) {
                rootElement = (EObject)root;
            }
        } else {
            rootElement = this.createRootElement();
        }
        return rootElement;
    }

    protected EObject createRootElement() {
        return UMLFactory.eINSTANCE.createModel();
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    protected void initializeModel(EObject owner) {
        Package roboticsLib;
        Profile bt;
        Profile robotics;
        Package packageOwner = (Package)owner;
        Profile bpc = (Profile)PackageUtil.loadPackage((URI)BPCResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet());
        if (bpc != null) {
            PackageUtil.applyProfile((Package)packageOwner, (Profile)bpc, (boolean)true);
        }
        if ((robotics = (Profile)PackageUtil.loadPackage((URI)RoboticsResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet())) != null) {
            List<String> profileNames = Arrays.asList("generics", "skills", "behavior");
            for (String name : profileNames) {
                Profile profile = (Profile)robotics.getOwnedMember(name);
                if (profile == null) continue;
                PackageUtil.applyProfile((Package)packageOwner, (Profile)profile, (boolean)true);
            }
        }
        if ((bt = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)"pathmap://Robotics_PROFILES_BT/bt.profile.uml"), (ResourceSet)owner.eResource().getResourceSet())) != null) {
            PackageUtil.applyProfile((Package)packageOwner, (Profile)bt, (boolean)true);
        }
        if ((roboticsLib = PackageUtil.loadPackage((URI)RoboticsLibResource.ROBOTICS_LIB_URI, (ResourceSet)owner.eResource().getResourceSet())) != null) {
            Package skillLib = (Package)roboticsLib.getOwnedMember("skills");
            if (roboticsLib != null) {
                PackageImport pi = UMLFactory.eINSTANCE.createPackageImport();
                pi.setImportedPackage(skillLib);
                packageOwner.getPackageImports().add((Object)pi);
            }
        }
        packageOwner.setName(this.getModelName());
        StereotypeUtil.apply((Element)packageOwner, org.eclipse.papyrus.robotics.profile.robotics.generics.Package.class);
    }

    protected String getModelName() {
        return "BtModel";
    }
}

