/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppModelElementsCreator;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.ros2.codegen.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ProjectTools;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class RoboticsCppCreator
extends CppModelElementsCreator {
    String skeletonFolder;
    String userSrcFolder;

    public RoboticsCppCreator(IPFileSystemAccess fileAccess, String skeletonFolder, String userSrcFolder) {
        super(fileAccess, null);
        this.skeletonFolder = skeletonFolder;
        this.userSrcFolder = userSrcFolder;
    }

    protected void generateFile(String fileName, String content) {
        if (TransformationContext.monitor.isCanceled()) {
            throw Exceptions.sneakyThrow((Throwable)new TransformationException(ExecuteTransformationChain.USER_CANCEL));
        }
        ProjectTools.waitForCDT();
        TransformationContext.monitor.subTask("generate file " + fileName);
        TransformationContext.monitor.worked(1);
        if (fileName.startsWith(this.skeletonFolder)) {
            IFileExists existsFSA;
            String srcFileName = fileName.replaceFirst(this.skeletonFolder, this.userSrcFolder);
            if (this.fileSystemAccess instanceof IFileExists && !(existsFSA = (IFileExists)this.fileSystemAccess).existsFile(srcFileName)) {
                super.generateFile(srcFileName, content);
            }
        }
        super.generateFile(fileName, content);
    }

    public String getFileName(NamedElement element) {
        if (element.getName() != null && element.getName().endsWith(CodeSkeleton.POSTFIX)) {
            return String.valueOf(this.skeletonFolder) + this.locStrategy.getFileName(element);
        }
        return super.getFileName(element);
    }
}

