/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.diagrams.dnd.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.command.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class DropComponentDefinitionAsComponentInstanceCommand
extends AbstractTransactionalCommand {
    protected static final int PORT_DEFAULT_HEIGHT = 20;
    protected static final int WIDTH_FACTOR = 11;
    protected static final int MIN_WIDTH = 150;
    protected static final int MIN_HEIGHT = 150;
    protected static final double X_FONT_HEIGHT_FACTOR = 0.9;
    protected static final double Y_FONT_HEIGHT_FACTOR = 0.85;
    protected static final double X_WEST_OFFSET = 8.0;
    protected static final int Y_LABEL_OFFSET = 20;
    protected Class target;
    protected Class source;
    protected DropObjectsRequest request;
    protected Property newPart;
    protected GraphicalEditPart targetGraphicalEditPart;
    protected View targetView;
    protected TransactionalEditingDomain domain;

    public DropComponentDefinitionAsComponentInstanceCommand(DropObjectsRequest request, TransactionalEditingDomain domain, Class containerClass, Class sourceType, GraphicalEditPart targetEditPart, View targetView) {
        super(domain, "Create a composite part (ComponentInstance) from ComponentDefinition and create graphical view", DropComponentDefinitionAsComponentInstanceCommand.getWorkspaceFiles((EObject)containerClass));
        this.target = containerClass;
        this.source = sourceType;
        this.request = request;
        this.targetGraphicalEditPart = targetEditPart;
        this.targetView = targetView;
        this.domain = domain;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createNewPart();
        StereotypeUtil.apply((Element)this.newPart, ComponentInstance.class);
        this.createGraphicalViews();
        this.request.setResult((Object)this.newPart);
        return CommandResult.newOKCommandResult((Object)this.newPart);
    }

    protected void createNewPart() {
        String partName = this.source.getName();
        this.newPart = this.target.createOwnedAttribute(partName, (Type)this.source);
        this.newPart.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)partName, (Collection)this.target.getOwnedAttributes()));
        this.newPart.setAggregation(AggregationKind.COMPOSITE_LITERAL);
    }

    protected void createGraphicalViews() {
        List<Port> allPorts = this.collectPorts(this.newPart);
        int figureWidth = Math.max(150, 11 * this.newPart.getName().length());
        int maxPortOnOneSide = allPorts.size() % 2 == 0 ? allPorts.size() / 2 : allPorts.size() / 2 + 1;
        int figureHeight = Math.max(150, (2 * maxPortOnOneSide + 1) * 20);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)this.newPart), Node.class, ((IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)this.targetView, (EObject)this.newPart))).getSemanticHint(), this.targetGraphicalEditPart.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.domain, descriptor, this.targetView);
        try {
            createCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Point location = this.request.getLocation().getCopy();
        this.targetGraphicalEditPart.getContentPane().translateToRelative((Translatable)location);
        Dimension dimension = new Dimension(figureWidth, figureHeight);
        Rectangle partRectangle = new Rectangle(location, dimension);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.domain, "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), partRectangle);
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.createPorts(allPorts.subList(0, maxPortOnOneSide), allPorts.subList(maxPortOnOneSide, allPorts.size()), partRectangle, (IAdaptable)createCommand.getCommandResult().getReturnValue());
    }

    private void createPorts(List<Port> inPorts, List<Port> outPorts, Rectangle rectangle, IAdaptable figureAdapter) {
        Point proposedLocation;
        Port port;
        View view = (View)figureAdapter.getAdapter(View.class);
        int index = 0;
        while (index < inPorts.size()) {
            port = inPorts.get(index);
            proposedLocation = new Point(0, (index + 1) * rectangle.height / (inPorts.size() + 1));
            this.createPortView(port, proposedLocation, view, PositionKind.EAST);
            ++index;
        }
        index = 0;
        while (index < outPorts.size()) {
            port = outPorts.get(index);
            proposedLocation = new Point(rectangle.width, (index + 1) * rectangle.height / (outPorts.size() + 1));
            this.createPortView(port, proposedLocation, view, PositionKind.WEST);
            ++index;
        }
    }

    private void createPortView(Port port, Point location, View view, PositionKind position) {
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)port), Node.class, ((IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)view, (EObject)port))).getSemanticHint(), this.targetGraphicalEditPart.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.domain, descriptor, view);
        try {
            createCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.domain, "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private List<Port> collectPorts(Property newPart) {
        ArrayList<Port> ret = new ArrayList<Port>();
        Class partType = (Class)newPart.getType();
        for (Port port : partType.getOwnedPorts()) {
            if (!StereotypeUtil.isApplied((Element)port, ComponentPort.class)) continue;
            ret.add(port);
        }
        return ret;
    }

    static enum PositionKind {
        EAST,
        WEST;

    }
}

