/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.robotics.assertions.languages.ExpressionLanguagesHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;

public class ValidateAssertionHandler
extends AbstractHandler {
    public static EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if (selection instanceof EObject) {
                eObject = (EObject)selection;
            }
        }
        return eObject;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedObject = ValidateAssertionHandler.getSelectedElement();
        if (selectedObject instanceof Constraint) {
            Constraint constraint = (Constraint)selectedObject;
            Object result = ValidateAssertionHandler.evaluateConstraint(constraint);
            if (result != null && result.toString().equalsIgnoreCase("true")) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Assertion", (String)"Assertion is satisfied");
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Validate Assertion", (String)("Assertion is not satisfied\nReturned value: " + result));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        EObject eObject = ValidateAssertionHandler.getSelectedElement();
        return eObject instanceof Constraint;
    }

    public static Object evaluateConstraint(Constraint constraint) {
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)constraint.getSpecification();
            int indexOfLangBody = -1;
            String langName = null;
            int i = 0;
            while (i < opaqueExpression.getLanguages().size() && indexOfLangBody == -1) {
                langName = (String)opaqueExpression.getLanguages().get(i);
                if (ExpressionLanguagesHelper.getExpressionLanguageByName((String)langName) != null) {
                    indexOfLangBody = i;
                }
                ++i;
            }
            if (indexOfLangBody != -1) {
                IExpressionLanguage lang = ExpressionLanguagesHelper.getExpressionLanguageByName(langName);
                Object result = lang.evaluate((EObject)constraint.getContext(), (String)opaqueExpression.getBodies().get(indexOfLangBody));
                return result;
            }
        } else {
            return constraint.getSpecification().stringValue();
        }
        return null;
    }
}

