/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.papyrus.robotics.ros2.launch.Activator;
import org.eclipse.papyrus.robotics.ros2.launch.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RoboticsRunConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String ICON_P4R_PNG = "/icons/robotics-16x16.png";
    protected static String TAB_NAME = "Robotics Main";
    protected Composite mainContainer;
    protected Image image;
    Label pkgNameLabel;
    Text pkgNameText;
    Label scriptLabel;
    Text scriptText;

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.pkgNameText.setText(configuration.getAttribute("pkgName", ""));
            this.scriptText.setText(configuration.getAttribute("launchScript", ""));
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("pkgName", this.pkgNameText.getText());
        configuration.setAttribute("launchScript", this.scriptText.getText());
    }

    public void createControl(Composite parent) {
        this.mainContainer = new Composite(parent, 4);
        this.mainContainer.setLayout((Layout)new GridLayout(2, false));
        GridData descriptionGD = new GridData();
        descriptionGD.horizontalAlignment = 4;
        descriptionGD.grabExcessHorizontalSpace = true;
        this.pkgNameLabel = new Label(this.mainContainer, 0);
        this.pkgNameLabel.setText(Messages.RoboticsRunConfigurationTab_PKG_NAME);
        this.pkgNameText = new Text(this.mainContainer, 64);
        this.pkgNameText.setLayoutData((Object)descriptionGD);
        this.pkgNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RoboticsRunConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.scriptLabel = new Label(this.mainContainer, 0);
        this.scriptLabel.setText(Messages.RoboticsRunConfigurationTab_LAUNCH_SCRIPT);
        this.scriptText = new Text(this.mainContainer, 64);
        this.scriptText.setLayoutData((Object)descriptionGD);
        this.setControl((Control)this.mainContainer);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = new Image((Device)Display.getCurrent(), org.eclipse.papyrus.robotics.diagrams.Activator.getDefault().getClass().getResourceAsStream(ICON_P4R_PNG));
        }
        return this.image;
    }
}

