/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.uml2.uml.Behavior;

public class FunctionUtils {
    public static final String HANDLER = "handler";
    public static final String GOAL = "goal";
    public static final String R_FEEDBACK = "feedback";
    public static final String R_RESULT = "result";
    public static final String P_CANCEL = "cancel";
    public static final String P_ACCEPTED = "accepted";

    public static Behavior getFunction(ActivityPort activityPort, FunctionKind kind, String nameFilter) {
        for (Function fct : activityPort.getFunctions()) {
            if (fct.getKind() != kind || !(fct.getBase_Class() instanceof Behavior)) continue;
            Behavior base = (Behavior)fct.getBase_Class();
            if (nameFilter != null && !base.getName().toLowerCase().contains(nameFilter)) continue;
            return base;
        }
        return null;
    }

    public static Behavior getFunction(Activity activity, FunctionKind kind) {
        for (Function fct : activity.getFunctions()) {
            if (fct.getKind() != kind || !(fct.getBase_Class() instanceof Behavior)) continue;
            Behavior base = (Behavior)fct.getBase_Class();
            return base;
        }
        return null;
    }

    public static Behavior getFunction(ActivityPort activityPort, FunctionKind kind) {
        return FunctionUtils.getFunction(activityPort, kind, null);
    }
}

