/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ImportUtils {
    public static void createImportFromObj(Object obj) {
        if (obj instanceof Element) {
            ImportUtils.createImport((Element)obj);
        }
    }

    public static void createImport(Element element) {
        ResourceSet rs = element.eResource().getResourceSet();
        if (rs instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)rs;
            Resource umlR = UmlUtils.getUmlResource((ModelSet)modelSet);
            Package root = (Package)umlR.getContents().get(0);
            final Package pkgToImport = PackageUtil.getRootPackage((Element)element);
            if (pkgToImport != root && !root.getImportedPackages().contains((Object)pkgToImport)) {
                CommandStack stack = modelSet.getTransactionalEditingDomain().getCommandStack();
                final IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)root);
                CompositeCommand cc = new CompositeCommand("Create package import");
                CreateElementRequest createPiReq = new CreateElementRequest((EObject)root, (IElementType)UMLElementTypes.PACKAGE_IMPORT);
                final ICommand createPiCmd = provider.getEditCommand((IEditCommandRequest)createPiReq);
                CompositeCommand wrapper = new CompositeCommand("wrapper"){
                    boolean first;
                    {
                        super($anonymous0);
                        this.first = true;
                    }

                    public boolean canExecute() {
                        if (this.first) {
                            return true;
                        }
                        return super.canExecute();
                    }

                    public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        if (this.first) {
                            Object result = createPiCmd.getCommandResult().getReturnValue();
                            if (result instanceof EObject) {
                                SetRequest setPackageReq = new SetRequest((EObject)result, (EStructuralFeature)UMLPackage.eINSTANCE.getPackageImport_ImportedPackage(), (Object)pkgToImport);
                                ICommand setPackageCmd = provider.getEditCommand((IEditCommandRequest)setPackageReq);
                                this.add((IUndoableOperation)setPackageCmd);
                            }
                            this.first = false;
                        }
                        return super.execute(progressMonitor, info);
                    }
                };
                cc.add((IUndoableOperation)createPiCmd);
                cc.add((IUndoableOperation)wrapper);
                stack.execute(GMFtoEMFCommandWrapper.wrap((ICommand)cc));
            }
        }
    }
}

