/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.papyrus.infra.widgets.databinding.StyledTextObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.papyrus.robotics.assertions.languages.AssertionsHelper;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StyledStringEditor
extends AbstractValueEditor
implements KeyListener,
ModifyListener {
    protected final StyledText styledText;
    private int delay = 600;
    private boolean validateOnDelay = false;
    private Timer timer;
    private TimerTask currentValidateTask;
    private TimerTask changeColorTask;
    private static final int DEFAULT_HEIGHT_HINT = 55;
    private static final int DEFAULT_WIDTH_HINT = 100;
    private String[] keywords;
    private List<String> modelKeywords;
    private Color keywordsColor = new Color((Device)Display.getCurrent(), 102, 0, 102);
    private Color modelKeywordsColor = new Color((Device)Display.getCurrent(), 120, 150, 0);

    public StyledStringEditor(Composite parent, int style) {
        this(parent, style, null, 55, 100);
    }

    public StyledStringEditor(Composite parent, int style, String label) {
        this(parent, style, label, 55, 100);
    }

    public StyledStringEditor(Composite parent, int style, int heighHint, int widthHint) {
        this(parent, style, null, heighHint, widthHint);
    }

    public StyledStringEditor(Composite parent, int style, String label, int heighHint, int widthHint) {
        super(parent, label);
        GridData data = this.getDefaultLayoutData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        if ((style & 2) != 0) {
            data.minimumHeight = heighHint;
            data.minimumWidth = widthHint;
            style |= 0x200;
        }
        this.styledText = new StyledText((Composite)this, 0x800 | style | Window.getDefaultOrientation());
        this.styledText.setLayoutData((Object)data);
        if (label != null) {
            this.label.setLayoutData((Object)this.getLabelLayoutData());
        }
        this.styledText.addKeyListener((KeyListener)this);
        this.styledText.addModifyListener((ModifyListener)this);
        this.setCommitOnFocusLost((Control)this.styledText);
        this.controlDecoration = new ControlDecoration((Control)this.styledText, 16512);
        this.controlDecoration.hide();
        data.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.pack();
    }

    protected GridData getLabelLayoutData() {
        GridData result = super.getLabelLayoutData();
        if (this.styledText != null && (this.styledText.getStyle() & 2) != 0) {
            result.verticalAlignment = 1;
        }
        return result;
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            if ((this.styledText.getStyle() & 2) == 0) {
                if (e.stateMask == 0) {
                    this.notifyChange();
                }
            } else if (e.stateMask == 262144) {
                String str = this.styledText.getText();
                if (str.endsWith(StringSelector.LINE_SEPARATOR)) {
                    int newLength = str.length() - StringSelector.LINE_SEPARATOR.length();
                    this.styledText.setText(str.substring(0, newLength));
                    this.styledText.setSelection(newLength);
                }
                this.notifyChange();
            }
        }
        this.updateSyntaxHighlighting();
    }

    public void setModelObservable(IObservableValue observable) {
        this.setWidgetObservable((IObservableValue)new StyledTextObservableValue(this.styledText, observable, 16), true);
        super.setModelObservable(observable);
    }

    public Object getEditableType() {
        return String.class;
    }

    public Object getValue() {
        return this.styledText.getText();
    }

    public void setReadOnly(boolean readOnly) {
        this.styledText.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.styledText.isEnabled();
    }

    protected void notifyChange() {
        this.styledText.notifyListeners(16, new Event());
        this.commit();
        this.changeColorField();
    }

    public void setToolTipText(String tooltip) {
        this.styledText.setToolTipText(tooltip);
        super.setLabelToolTipText(tooltip);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.styledText.setText((String)value);
        } else {
            this.styledText.setText("");
        }
        this.updateSyntaxHighlighting();
    }

    public void setValidateOnDelay(boolean validateOnDelay) {
        this.validateOnDelay = validateOnDelay;
        if (validateOnDelay) {
            this.styledText.addModifyListener((ModifyListener)this);
        } else {
            this.styledText.removeModifyListener((ModifyListener)this);
            this.cancelCurrentTask();
        }
    }

    public void setValidateOnDelay(int millis) {
        this.delay = millis;
        this.setValidateOnDelay(true);
        if (this.delay == 0) {
            this.cancelCurrentTask();
        }
    }

    private void cancelCurrentTask() {
        if (this.currentValidateTask != null) {
            this.currentValidateTask.cancel();
            this.currentValidateTask = null;
        }
    }

    public void modifyText(ModifyEvent e) {
        IStatus status;
        if (this.validateOnDelay) {
            if (this.delay == 0) {
                this.commit();
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelCurrentTask();
            this.currentValidateTask = new TimerTask(){

                @Override
                public void run() {
                    StyledStringEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            StyledStringEditor.this.commit();
                        }
                    });
                }
            };
            this.timer.schedule(this.currentValidateTask, this.delay);
        }
        if (this.targetValidator != null) {
            status = this.targetValidator.validate((Object)this.styledText.getText());
            this.updateStatus(status);
        }
        if (this.modelValidator != null) {
            status = this.modelValidator.validate((Object)this.styledText.getText());
            this.updateStatus(status);
            if (this.binding == null) {
                this.update();
            }
        }
        if (this.modelProperty != null) {
            if (this.modelProperty.getValue() != null) {
                if (!this.isReadOnly() && !this.modelProperty.getValue().toString().equals(this.styledText.getText())) {
                    this.styledText.setBackground(EDIT);
                } else {
                    this.styledText.setBackground(DEFAULT);
                }
            } else if (this.styledText.getText().equals("")) {
                this.styledText.setBackground(DEFAULT);
            } else {
                this.styledText.setBackground(EDIT);
            }
        }
    }

    public void dispose() {
        this.cancelCurrentTask();
        this.cancelChangeColorTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.dispose();
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.controlDecoration.hide();
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(status.getMessage());
                this.controlDecoration.setDescriptionText(status.getMessage());
                this.controlDecoration.show();
                break;
            }
            default: {
                this.controlDecoration.hide();
            }
        }
    }

    public void changeColorField() {
        if (this.binding != null) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.cancelChangeColorTask();
            this.changeColorTask = new TimerTask(){

                @Override
                public void run() {
                    if (StyledStringEditor.this.isDisposed()) {
                        return;
                    }
                    StyledStringEditor.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).StyledStringEditor.this.styledText.setBackground(DEFAULT);
                            (this).StyledStringEditor.this.styledText.update();
                        }
                    });
                }
            };
            if (this.errorBinding) {
                this.styledText.setBackground(ERROR);
                this.styledText.update();
            } else {
                IStatus status = (IStatus)this.binding.getValidationStatus().getValue();
                switch (status.getSeverity()) {
                    case 0: 
                    case 2: {
                        this.timer.schedule(this.changeColorTask, 600L);
                        this.styledText.setBackground(VALID);
                        this.styledText.update();
                        break;
                    }
                    case 4: {
                        this.styledText.setBackground(ERROR);
                        this.styledText.update();
                    }
                }
            }
        }
    }

    private void cancelChangeColorTask() {
        if (this.changeColorTask != null) {
            this.changeColorTask.cancel();
            this.changeColorTask = null;
        }
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void updateSyntaxHighlighting() {
        String s = this.styledText.getText();
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.applyHighlight(this.styledText, s, keyword, this.keywordsColor, 1);
            ++n2;
        }
        for (String keyword : this.modelKeywords) {
            this.applyHighlight(this.styledText, s, keyword, this.modelKeywordsColor, 1);
        }
        this.applyHighlight(this.styledText, s, "GlobalSum", this.keywordsColor, 1);
    }

    public void applyHighlight(StyledText styledText, String expression, String keyword, Color keywordsColor, int fontStyle) {
        int i = expression.indexOf(keyword);
        while (i != -1) {
            boolean valid = false;
            if (keyword.equals("GlobalSum")) {
                valid = true;
            }
            if (i == 0) {
                if (expression.startsWith(String.valueOf(keyword) + " ") || expression.equals(keyword)) {
                    valid = true;
                }
            } else if (i + keyword.length() == expression.length()) {
                if (expression.charAt(i - 1) == ' ') {
                    valid = true;
                }
            } else if (!(expression.charAt(i - 1) != ' ' && expression.charAt(i - 1) != '(' || expression.charAt(i + keyword.length()) != ' ' && expression.charAt(i + keyword.length()) != ')')) {
                valid = true;
            }
            if (valid) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = i;
                styleRange.length = keyword.length();
                styleRange.fontStyle = fontStyle;
                styleRange.foreground = keywordsColor;
                styledText.setStyleRange(styleRange);
            }
            i = expression.indexOf(keyword, i + keyword.length());
        }
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 32) {
            ArrayList<String> elementsList = new ArrayList<String>();
            String[] stringArray = this.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                elementsList.add(keyword);
                ++n2;
            }
            elementsList.addAll(this.modelKeywords);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return "";
                    }
                    return element.toString();
                }

                public Image getImage(Object element) {
                    if (StyledStringEditor.this.modelKeywords.contains(element)) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
                    }
                    return null;
                }
            });
            dialog.setElements(elementsList.toArray());
            dialog.setTitle("Auto-completion");
            dialog.setMultipleSelection(false);
            dialog.setHelpAvailable(false);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                int selIndex = this.styledText.getSelection().x;
                String text = this.styledText.getText();
                String before = text.substring(0, selIndex);
                String after = text.substring(selIndex);
                this.styledText.setText(String.valueOf(before) + result[0] + after);
                this.updateSyntaxHighlighting();
            }
        }
    }

    public void setContext(EObject currentEObj) {
        this.modelKeywords = new ArrayList<String>();
        EObject parent = currentEObj;
        while (parent.eContainer() != null) {
            Map<String, ValueSpecification> properties;
            if ((parent = parent.eContainer()) instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)parent), ComponentDefinition.class) != null) {
                ComponentDefinition compDefinition = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)((Element)parent), ComponentDefinition.class);
                this.modelKeywords.addAll(this.getPortNames(compDefinition));
                properties = AssertionsHelper.getProperties((EObject)compDefinition.getBase_Class());
                this.modelKeywords.addAll(properties.keySet());
                this.modelKeywords.addAll(this.getParameterNames((EObject)compDefinition.getBase_Class()));
                continue;
            }
            if (!(parent instanceof Element) || UMLUtil.getStereotypeApplication((Element)((Element)parent), System.class) == null) continue;
            System system = (System)UMLUtil.getStereotypeApplication((Element)((Element)parent), System.class);
            properties = AssertionsHelper.getProperties((EObject)system.getBase_Class());
            this.modelKeywords.addAll(properties.keySet());
            for (ComponentInstance instance : system.getInstances()) {
                String instanceName = instance.getBase_Property().getName();
                this.modelKeywords.add(instanceName);
                ComponentOrSystem compDef = instance.getCompdefOrSys();
                for (String param : this.getParameterNames((EObject)compDef.getBase_Class())) {
                    this.modelKeywords.add(String.valueOf(instanceName) + "." + param);
                }
                Map<String, ValueSpecification> compProperties = AssertionsHelper.getProperties((EObject)compDef.getBase_Class());
                for (String prop : compProperties.keySet()) {
                    this.modelKeywords.add(String.valueOf(instanceName) + "." + prop);
                }
            }
        }
    }

    public List<String> getPortNames(ComponentDefinition compDef) {
        ArrayList<String> portNames = new ArrayList<String>();
        for (Port port : compDef.getBase_Class().getOwnedPorts()) {
            portNames.add(port.getName());
        }
        return portNames;
    }

    public List<String> getParameterNames(EObject context) {
        ArrayList<String> names = new ArrayList<String>();
        TreeIterator i = context.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            ParameterEntry parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)((Element)eo), ParameterEntry.class);
            if (parameter == null) continue;
            String name = parameter.getBase_Property().getName();
            names.add(name);
        }
        return names;
    }
}

