/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.tables.assertions;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AssertionTableCellManager
extends AbstractCellManager {
    private static final String NAME = "Name";
    private static final String LANGUAGE = "Language";
    private static final String EXPRESSION = "Expression";
    private static final String DESC = "Description";
    public static final String ASSERTION_TABLE = "AssertionTable";
    public static final String ASSUMPTIONS_TABLE = "AssumptionsTable";
    public static final String GUARANTEES_TABLE = "GuaranteesTable";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager mngr) {
        EObject parent;
        if (columnElement instanceof IAxis && (parent = ((IAxis)columnElement).eContainer()) != null) {
            parent = parent.eContainer();
            String type = ((Table)parent).getTableConfiguration().getType();
            if (parent instanceof Table && (type.equals(ASSERTION_TABLE) || type.equals(GUARANTEES_TABLE) || type.equals(ASSUMPTIONS_TABLE))) {
                return true;
            }
        }
        return false;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager mngr) {
        boolean isEditable = false;
        if (rowElement instanceof Constraint) {
            isEditable = true;
        }
        return isEditable;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        String alias;
        String value = "";
        String string = alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        if (rowElement instanceof Constraint && alias != null) {
            ParameterEntry parameter;
            Constraint c = (Constraint)rowElement;
            OpaqueExpression oe = null;
            if (c == null || !(c.getSpecification() instanceof OpaqueExpression)) {
                return null;
            }
            oe = (OpaqueExpression)c.getSpecification();
            if (alias.equals(NAME)) {
                return c.getName();
            }
            if (alias.equals(LANGUAGE)) {
                if (oe.getLanguages().size() > 0) {
                    return oe.getLanguages().get(0);
                }
            } else if (alias.equals(EXPRESSION)) {
                if (oe.getBodies().size() > 0) {
                    return oe.getBodies().get(0);
                }
            } else if (alias.equals(DESC) && c != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)c, ParameterEntry.class)) != null) {
                return parameter.getDescription();
            }
        }
        return value;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        String text;
        String alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        Constraint constraint = (Constraint)rowElement;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)constraint);
        CompositeCommand editingCommand = new CompositeCommand(null);
        if (newValue instanceof String && (text = (String)newValue) != null) {
            if (alias.equals(NAME)) {
                SetRequest setNameReq = new SetRequest(domain, (EObject)constraint, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)text);
                editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setNameReq));
            } else if (alias.equals(EXPRESSION)) {
                text = StringUtils.unquote((String)text);
                if (constraint.getSpecification() instanceof OpaqueExpression) {
                    OpaqueExpression expression = (OpaqueExpression)constraint.getSpecification();
                    if (provider != null) {
                        EList bodies = expression.getBodies();
                        ArrayList<String> newBodies = new ArrayList<String>();
                        newBodies.add(text);
                        if (!bodies.isEmpty()) {
                            newBodies.addAll(bodies.subList(1, bodies.size()));
                        } else {
                            ArrayList<String> newLanguages = new ArrayList<String>();
                            newLanguages.add("Matlab");
                            SetRequest languageRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Language(), newLanguages);
                            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)languageRequest));
                        }
                        SetRequest bodiesRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Body(), newBodies);
                        editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)bodiesRequest));
                    }
                }
            }
        }
        return new GMFtoEMFCommandWrapper((ICommand)editingCommand);
    }
}

