/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.library.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.menu.MenuHelper;
import org.eclipse.papyrus.robotics.core.provider.EClassGraphicalContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.library.advice.AdviceUtil;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinition;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UMLPackage;

public class EventCommPatternAdvice
extends AbstractEditHelperAdvice {
    public static final String QNAME = "robotics::commpatterns::Event";
    public static final String EVENT_PREFIX = "E_";

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        DataType state;
        DataType parameter;
        DataType event;
        CompositeCommand compositeCommand = new CompositeCommand("Event pattern configuration command");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Classifier)) {
            return super.getAfterConfigureCommand(request);
        }
        final Classifier classifier = (Classifier)newElement;
        RoboticsContentProvider cp = new RoboticsContentProvider((EObject)classifier, (IStaticContentProvider)new EClassGraphicalContentProvider((EObject)classifier, UMLPackage.eINSTANCE.getDataType()), CommunicationObject.class, ".servicedef.uml");
        EnhancedPopupMenu popupMenuEvent = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for event", (boolean)false);
        Object menuResult = null;
        if (popupMenuEvent.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuEvent.getSubResult();
        }
        DataType dataType = event = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (event == null) {
            return new CancelCommand((EObject)classifier);
        }
        EnhancedPopupMenu popupMenuParam = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for parameter", (boolean)false);
        if (popupMenuParam.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuParam.getSubResult();
        }
        DataType dataType2 = parameter = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (parameter == null) {
            return new CancelCommand((EObject)classifier);
        }
        EnhancedPopupMenu popupMenuState = MenuHelper.createPopupMenu((IStaticContentProvider)cp, (String)"Choose CO for state", (boolean)false);
        if (popupMenuState.show((Control)Display.getDefault().getActiveShell())) {
            menuResult = popupMenuState.getSubResult();
        }
        DataType dataType3 = state = menuResult instanceof DataType ? (DataType)menuResult : null;
        if (state == null) {
            return new CancelCommand((EObject)classifier);
        }
        RecordingCommand templateBinding = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                Classifier eventCommPattern = AdviceUtil.getPattern((Element)classifier, EventCommPatternAdvice.QNAME);
                if (eventCommPattern != null) {
                    TemplateSignature signature = eventCommPattern.getOwnedTemplateSignature();
                    TemplateBinding binding = classifier.createTemplateBinding(signature);
                    String name = EventCommPatternAdvice.EVENT_PREFIX.substring(0, 1);
                    for (TemplateParameter tp : signature.getOwnedParameters()) {
                        TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                        substitution.setFormal(tp);
                        String formalName = ((NamedElement)tp.getParameteredElement()).getName();
                        if (formalName.equals("Event")) {
                            substitution.setActual((ParameterableElement)event);
                            name = String.valueOf(name) + "_" + event.getName();
                            continue;
                        }
                        if (formalName.equals("Parameter")) {
                            substitution.setActual((ParameterableElement)parameter);
                            name = String.valueOf(name) + "_" + parameter.getName();
                            continue;
                        }
                        if (!formalName.equals("State")) continue;
                        substitution.setActual((ParameterableElement)state);
                        name = String.valueOf(name) + "_" + state.getName();
                    }
                    classifier.setName(name);
                }
                StereotypeUtil.apply((Element)classifier, ServiceDefinition.class);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)templateBinding));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

