/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.component;

import org.eclipse.papyrus.designer.languages.python.profile.python.Main;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.ApplyPythonProfile;
import org.eclipse.papyrus.robotics.ros2.codegen.python.utils.RosPythonTypes;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class CreateMain {
  /**
   * Create the main entry point for a class
   */
  public static Dependency createMain(final org.eclipse.uml2.uml.Class component) {
    try {
      Dependency _xblockexpression = null;
      {
        org.eclipse.uml2.uml.Package _nearestPackage = component.getNearestPackage();
        String _name = component.getName();
        String _plus = (_name + "_main");
        final org.eclipse.uml2.uml.Class mainClass = _nearestPackage.createOwnedClass(_plus, false);
        org.eclipse.uml2.uml.Package _nearestPackage_1 = component.getNearestPackage();
        String _name_1 = component.getName();
        String _plus_1 = (_name_1 + CodeSkeleton.POSTFIX);
        NamedElement _ownedMember = _nearestPackage_1.getOwnedMember(_plus_1);
        final org.eclipse.uml2.uml.Class implClass = ((org.eclipse.uml2.uml.Class) _ownedMember);
        ApplyPythonProfile.apply(mainClass);
        final Main mainST = StereotypeUtil.<Main>applyApp(mainClass, Main.class);
        mainST.setBody(CreateMain.createMainCode(component).toString());
        if ((implClass != null)) {
          mainClass.createDependency(implClass);
        } else {
          mainClass.createDependency(component);
        }
        _xblockexpression = mainClass.createDependency(RosPythonTypes.getRclPy(mainClass));
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static CharSequence createMainCode(final org.eclipse.uml2.uml.Class component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("rclpy.init()");
    _builder.newLine();
    String _lowerCase = component.getName().toLowerCase();
    _builder.append(_lowerCase);
    _builder.append(" = ");
    String _name = component.getName();
    _builder.append(_name);
    {
      boolean _hasExternalCode = ActivityUtils.hasExternalCode(component);
      if (_hasExternalCode) {
        _builder.append(CodeSkeleton.POSTFIX);
      }
    }
    _builder.append("(\'");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("_node\')");
    _builder.newLineIfNotEmpty();
    String _lowerCase_1 = component.getName().toLowerCase();
    _builder.append(_lowerCase_1);
    _builder.append(".get_logger().info(\'");
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append(" node has been created\')");
    _builder.newLineIfNotEmpty();
    {
      int _size = ParameterUtils.getAllParameters(component).size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _lowerCase_2 = component.getName().toLowerCase();
        _builder.append(_lowerCase_2);
        _builder.append(".declareParameters()");
        _builder.newLineIfNotEmpty();
        String _lowerCase_3 = component.getName().toLowerCase();
        _builder.append(_lowerCase_3);
        _builder.append(".initParameterVars()");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("executor = rclpy.executors.MultiThreadedExecutor()");
    _builder.newLine();
    _builder.append("executor.add_node(");
    String _lowerCase_4 = component.getName().toLowerCase();
    _builder.append(_lowerCase_4);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("executor.spin()");
    _builder.newLine();
    _builder.append("rclpy.shutdown()");
    _builder.newLine();
    return _builder;
  }
}
