/*****************************************************************************
 * Copyright (c) 2022 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *
 *****************************************************************************/

package org.eclipse.papyrus.robotics.ros2.preferences;

/**
 * Utility functions around ROS 2 version, including a definition
 * of different names and literals
 */
public class Ros2Distributions {
	public static final String FOXY = "foxy"; //$NON-NLS-1$
	public static final String ELOQUENT = "eloquent"; //$NON-NLS-1$
	public static final String GALACTIC = "galactic"; //$NON-NLS-1$
	public static final String HUMBLE = "humble"; //$NON-NLS-1$

	public enum RDLiteral {
		UNKNOWN, FOXY, ELOQUENT, GALACTIC, HUMBLE
	}

	/**
	 * Return the ROS distribution as enumeration literal
	 * 
	 * @return the configured ROS distribution or UNKNOWN
	 */
	public static RDLiteral getRosDistro() {
		String rosDistro = Ros2PreferenceUtils.getRosDistroStr();
		if (Ros2Distributions.ELOQUENT.equals(rosDistro)) {
			return RDLiteral.FOXY;
		} else if (Ros2Distributions.ELOQUENT.equals(rosDistro)) {
			return RDLiteral.ELOQUENT;
		} else if (Ros2Distributions.GALACTIC.equals(rosDistro)) {
			return RDLiteral.GALACTIC;
		} else if (Ros2Distributions.HUMBLE.equals(rosDistro)) {
			return RDLiteral.HUMBLE;
		}
		return RDLiteral.UNKNOWN;
	}
}
