/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.robotics.ros2.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;


public class Ros2PreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	@SuppressWarnings("nls")
	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		store.setDefault(Ros2PreferenceConstants.P_ROS_DISTRO, Ros2Distributions.HUMBLE);
		store.setDefault(Ros2PreferenceConstants.P_SETUP_PATH, "/opt/ros/" + Ros2Distributions.HUMBLE);
		store.setDefault(Ros2PreferenceConstants.P_COLCON_OPTIONS, "--symlink-install");
		store.setDefault(Ros2PreferenceConstants.P_COLCON_PACKAGES, "--packages-up-to");
		store.setDefault(Ros2PreferenceConstants.P_MAINTAINER_NAME, "maintainer");
		store.setDefault(Ros2PreferenceConstants.P_MAINTAINER_MAIL, "maintainer@somewhere.net");
		store.setDefault(Ros2PreferenceConstants.P_AUTHOR_NAME, "author");
		store.setDefault(Ros2PreferenceConstants.P_AUTHOR_MAIL, "author@somewhere.net");

		IPropertyChangeListener changeListener = new IPropertyChangeListener() {

			@Override
			public void propertyChange(PropertyChangeEvent event) {
				// update ROS 2 environment variables
				if (event.getProperty() == Ros2PreferenceConstants.P_SETUP_PATH) {
					EnvironmentUtils.waitForSetupJob();
					EnvironmentUtils.runCheckAndApplySetupJob(Ros2PreferenceUtils.getSetupPath());
				}
			}
		};
		store.addPropertyChangeListener(changeListener);
	}
}
