/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.robotics.ros2.preferences;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Utility class that returns the preference values (eventually taking
 * stereotypes into account)
 */
public class Ros2PreferenceUtils {

	protected static IPreferenceStore preferenceStore = null;

	public static String getRosDistroStr() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_ROS_DISTRO);
	}

	public static String getSetupPath() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_SETUP_PATH);
	}

	public static String getColconOptions() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_COLCON_OPTIONS);
	}

	public static String getColconPackageOptions() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_COLCON_PACKAGES);
	}

	public static String getMaintainerName() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_MAINTAINER_NAME);
	}

	public static String getMaintainerMail() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_MAINTAINER_MAIL);
	}

	public static String getAuthorName() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_AUTHOR_NAME);
	}

	public static String getAuthorMail() {
		initPreferenceStore();
		return preferenceStore.getString(Ros2PreferenceConstants.P_AUTHOR_MAIL);
	}

	public static void initPreferenceStore() {
		if (preferenceStore == null) {
			preferenceStore = Activator.getDefault().getPreferenceStore();
		}
	}
}
