/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.wizards.wizards;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.robotics.wizards.wizards.NewRoboticsModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.PapyrusProjectCreationPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewRoboticsProjectWizard
extends NewRoboticsModelWizard {
    private static final String DOT = ".";
    private static final String SLASH = "/";
    public static final String WIZARD_ID = "org.eclipse.papyrus.robotics.wizards.createproject";
    private PapyrusProjectCreationPage myProjectPage;

    public boolean isCreateProjectWizard() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.NewPapyrusProjectWizard_new_papyrus_project);
        this.setMyProjectPage(new PapyrusProjectCreationPage(Messages.NewPapyrusProjectWizard_0));
        this.getMyProjectPage().setDescription(Messages.NewPapyrusProjectWizard_1);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.papyrus.uml.diagram.wizards", (String)"icons/papyrus/PapyrusProjectWizban_75x66.gif"));
    }

    public void addPages() {
        this.setNewProjectPage((IWizardPage)this.getMyProjectPage());
        this.selectArchitectureContextPage = new SelectArchitectureContextPage();
        super.addPages();
    }

    @Override
    public boolean performFinish() {
        IProject newProjectHandle;
        try {
            newProjectHandle = this.createNewProject();
        }
        catch (CoreException e) {
            Activator.log.error(Messages.NewPapyrusProjectWizard_exception_on_opening, (Throwable)e);
            return false;
        }
        if (newProjectHandle == null) {
            return false;
        }
        return super.performFinish();
    }

    protected IProject createNewProject() throws CoreException {
        IWorkingSet[] workingSets;
        IProject project = this.getMyProjectPage().getProjectHandle();
        java.net.URI projectLocationURI = null;
        if (!this.getMyProjectPage().useDefaults()) {
            projectLocationURI = this.getMyProjectPage().getLocationURI();
        }
        IProjectDescription projectDescription = null;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (!project.exists()) {
            projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (projectLocationURI != null) {
                projectDescription.setLocationURI(projectLocationURI);
            }
            project.create(projectDescription, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
            project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
            IFolder models = project.getFolder("models");
            models.create(true, true, null);
            String id = this.selectViewPointPage.getSelectedID();
            if (id != null && id.startsWith("org.eclipse.papyrus.robotics.viewpoint.")) {
                if (id.endsWith("ServiceDesign") || id.endsWith("BehaviorDesign")) {
                    IFolder services = models.getFolder("services");
                    services.create(true, true, null);
                    IFolder skills = models.getFolder("skills");
                    skills.create(true, true, null);
                } else {
                    IFolder components = models.getFolder("components");
                    components.create(true, true, null);
                    IFolder systems = models.getFolder("system");
                    systems.create(true, true, null);
                    IFolder btrees = models.getFolder("tasks");
                    btrees.create(true, true, null);
                    IFolder taskbasedhara = models.getFolder("taskbased-hara");
                    taskbasedhara.create(true, true, null);
                }
            }
        } else {
            project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1));
        }
        if ((workingSets = this.getMyProjectPage().getSelectedWorkingSets()).length > 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
        }
        return project;
    }

    protected URI createNewModelURI(String categoryId) {
        String extension = this.getExtension();
        String id = this.selectViewPointPage.getSelectedID();
        String folder = "";
        if (id.endsWith("ComponentDevelopment")) {
            folder = "components";
        } else if (id.endsWith("ServiceDesign")) {
            folder = "services";
        } else if (id.endsWith("SystemConfiguration")) {
            folder = "system";
        } else if (id.endsWith("BehaviorDesign")) {
            folder = "skills";
        } else if (id.endsWith("BehaviorTreeDesign")) {
            folder = "tasks";
        } else if (id.endsWith("TadkBasedHazardAnalysis")) {
            folder = "taskbased-hara";
        }
        IPath newFilePath = this.getMyProjectPage().getProjectHandle().getFullPath().append("models/" + folder + SLASH + this.getMyProjectPage().getFileName() + DOT + extension);
        return URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)true);
    }

    public PapyrusProjectCreationPage getMyProjectPage() {
        return this.myProjectPage;
    }

    public void setMyProjectPage(PapyrusProjectCreationPage myProjectPage) {
        this.myProjectPage = myProjectPage;
    }

    protected WizardNewProjectCreationPage createNewProjectCreationPage() {
        return this.myProjectPage;
    }
}

