/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.architecture.internal.migration;

import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler_1_3_0;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class SysMLNeonToOxygenDiagramReconciler
extends DiagramReconciler_1_3_0 {
    private static final String BLOCK_DEFINITION_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.blockdefinition/resources/configuration/blockDefinitionDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String INTERNAL_BLOCK_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.internalblock/resources/configuration/internalBlockDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String PARAMETRIC_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.parametric/resources/configuration/parametricDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String REQUIREMENT_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.requirement/resources/configuration/requirementDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String SYSML14_CONTEXT_ID = "org.eclipse.papyrus.sysml.architecture.SysML14";

    protected PapyrusDiagram getDiagramKind(Diagram diagram, PapyrusViewStyle oldStyle) {
        block16: {
            URI uri;
            PapyrusView configuration;
            if (oldStyle == null || (configuration = oldStyle.getConfiguration()) == null || (uri = EcoreUtil.getURI((EObject)configuration)) == null) break block16;
            switch (uri.toString()) {
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.requirement/resources/configuration/requirementDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.requirement");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.blockdefinition/resources/configuration/blockDefinitionDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.blockdefinition");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.internalblock/resources/configuration/internalBlockDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.internalblock");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.parametric/resources/configuration/parametricDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.parametric");
                }
            }
        }
        return null;
    }

    public ICommand getReconcileCommand(Diagram diagram) {
        ResourceSet resourceSet;
        Resource eResource;
        ICommand reconcileCommand = super.getReconcileCommand(diagram);
        if (reconcileCommand != null && diagram != null && (eResource = diagram.eResource()) != null && (resourceSet = eResource.getResourceSet()) instanceof ModelSet) {
            CompositeCommand compositeCommand = new CompositeCommand("Update viewpoints from configuration to architecture and set SysML 1.4 as default architecture");
            compositeCommand.add((IUndoableOperation)reconcileCommand);
            Command setContextCommand = this.getSetContextCommand((ModelSet)resourceSet, SYSML14_CONTEXT_ID);
            compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)setContextCommand));
            return compositeCommand;
        }
        return reconcileCommand;
    }

    protected Command getSetContextCommand(final ModelSet modelSet, final String contextId) {
        return new RecordingCommand(modelSet.getTransactionalEditingDomain()){

            protected void doExecute() {
                ArchitectureDescription description = DiModelUtils.getOrAddArchitectureDescription((ModelSet)modelSet);
                description.setContextId(contextId);
            }
        };
    }

    protected PapyrusDiagram getPapyrusDiagramById(String id) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        Collection visibleArchitectureContexts = manager.getVisibleArchitectureContexts();
        for (MergedArchitectureContext mergedArchitectureContext : visibleArchitectureContexts) {
            if (!(mergedArchitectureContext instanceof MergedArchitectureDescriptionLanguage)) continue;
            MergedArchitectureDescriptionLanguage mergedArchitectureDescriptionLanguage = (MergedArchitectureDescriptionLanguage)mergedArchitectureContext;
            for (RepresentationKind representationKind : mergedArchitectureDescriptionLanguage.getRepresentationKinds()) {
                if (!(representationKind instanceof PapyrusDiagram) || !representationKind.getId().equals(id)) continue;
                return (PapyrusDiagram)representationKind;
            }
        }
        return null;
    }
}

