/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.collection.CollectionAsBagOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsOrderedSetOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsSequenceOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionAsSetOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingAllOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionFlattenOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionIncludingAllOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionIncludingOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionIntersectionOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionMinOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionFirstOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionLastOperation;
import org.eclipse.ocl.pivot.library.iterator.AnyIteration;
import org.eclipse.ocl.pivot.library.iterator.CollectIteration;
import org.eclipse.ocl.pivot.library.iterator.RejectIteration;
import org.eclipse.ocl.pivot.library.iterator.SelectIteration;
import org.eclipse.ocl.pivot.library.iterator.SortedByIteration;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsSetOperation;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public abstract class TemplateParameterSubstitutionHelper {
    private static @NonNull Map<Class<? extends LibraryFeature>, TemplateParameterSubstitutionHelper> className2helper = new HashMap<Class<? extends LibraryFeature>, TemplateParameterSubstitutionHelper>();

    static {
        TemplateParameterSubstitutionHelper.addHelper(AnyIteration.class, new CollectionAnyHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectIteration.class, new CollectionCollectHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsBagOperation.class, new CollectionAsCollectionHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsOrderedSetOperation.class, new CollectionAsCollectionHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsSequenceOperation.class, new CollectionAsCollectionHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionAsSetOperation.class, new CollectionAsCollectionHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionExcludingOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionExcludingAllOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionIncludingOperation.class, new CollectionIncludingHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionIncludingAllOperation.class, new CollectionIncludingAllHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionIntersectionOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionMinOperation.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionAtOperation.class, new CollectionSourceElementHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionFirstOperation.class, new CollectionSourceElementHelper());
        TemplateParameterSubstitutionHelper.addHelper(OrderedCollectionLastOperation.class, new CollectionSourceElementHelper());
        TemplateParameterSubstitutionHelper.addHelper(CollectionFlattenOperation.class, new CollectionFlattenHelper());
        TemplateParameterSubstitutionHelper.addHelper(OclAnyOclAsSetOperation.class, new OclAnyOclAsSetHelper());
        TemplateParameterSubstitutionHelper.addHelper(RejectIteration.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(SelectIteration.class, new CollectionSourceHelper());
        TemplateParameterSubstitutionHelper.addHelper(SortedByIteration.class, new CollectionSourceHelper());
    }

    public void resolveUnmodeledTemplateParameterSubstitutions(@NonNull TemplateParameterSubstitutionVisitor templateParameterSubstitutions, @NonNull CallExp callExp) {
    }

    public @Nullable Type resolveBodyType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type bodyType) {
        return bodyType;
    }

    public boolean resolveReturnNullity(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, boolean returnIsRequired) {
        return returnIsRequired;
    }

    public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
        return returnType;
    }

    public static void addHelper(@NonNull Class<? extends LibraryFeature> className, @NonNull TemplateParameterSubstitutionHelper helper) {
        className2helper.put(className, helper);
    }

    public static @Nullable TemplateParameterSubstitutionHelper getHelper(@NonNull Class<? extends LibraryFeature> className) {
        return className2helper.get(className);
    }

    private static class CollectionAnyHelper
    extends CollectionSourceHelper {
        private CollectionAnyHelper() {
            super(null, null);
        }

        @Override
        public boolean resolveReturnNullity(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, boolean returnIsRequired) {
            CollectionType collectionType;
            Type sourceType;
            OCLExpression ownedSource;
            OCLExpression ownedBody = ((LoopExp)callExp).getOwnedBody();
            if (ownedBody instanceof BooleanLiteralExp && ((BooleanLiteralExp)ownedBody).isBooleanSymbol() && (ownedSource = callExp.getOwnedSource()) != null && (sourceType = ownedSource.getType()) instanceof CollectionType && (collectionType = (CollectionType)sourceType).isIsNullFree()) {
                return true;
            }
            return returnIsRequired;
        }
    }

    private static class CollectionAsCollectionHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionAsCollectionHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
                Type sourceType = ownedSource.getType();
                CollectionType returnCollectionType = (CollectionType)returnType;
                if (sourceType instanceof CollectionType) {
                    CollectionType sourceCollectionType = (CollectionType)sourceType;
                    Type elementType = PivotUtil.getElementType(sourceCollectionType);
                    returnType = metamodelManager.getCollectionType(returnCollectionType.isOrdered(), returnCollectionType.isUnique(), elementType, sourceCollectionType.isIsNullFree(), sourceCollectionType.getLowerValue(), sourceCollectionType.getUpperValue());
                }
            }
            return returnType;
        }
    }

    private static class CollectionCollectHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionCollectHelper() {
        }

        @Override
        public @Nullable Type resolveBodyType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type bodyType;
            LoopExp loopExp = (LoopExp)callExp;
            OCLExpression body = loopExp.getOwnedBody();
            Type asType = body != null ? body.getType() : null;
            Type type = bodyType = asType != null ? PivotUtilInternal.getNonLambdaType(asType) : null;
            if (bodyType != null) {
                @NonNull Type elementType = bodyType;
                while (elementType instanceof CollectionType) {
                    Type elementType2 = ((CollectionType)elementType).getElementType();
                    if (elementType2 == null) continue;
                    elementType = elementType2;
                }
                return elementType;
            }
            return returnType;
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type bodyType;
            LoopExp loopExp = (LoopExp)callExp;
            OCLExpression body = loopExp.getOwnedBody();
            Type asType = body != null ? body.getType() : null;
            Type type = bodyType = asType != null ? PivotUtilInternal.getNonLambdaType(asType) : null;
            if (bodyType != null) {
                @NonNull Type elementType = bodyType;
                while (elementType instanceof CollectionType) {
                    Type elementType2 = ((CollectionType)elementType).getElementType();
                    if (elementType2 == null) continue;
                    elementType = elementType2;
                }
                boolean isOrdered = returnType instanceof CollectionType && ((CollectionType)returnType).isOrdered();
                boolean isNullFree = asType instanceof CollectionType && ((CollectionType)asType).isIsNullFree();
                boolean isRequired = !(asType instanceof CollectionType) && body != null && body.isIsRequired();
                returnType = metamodelManager.getCollectionType(isOrdered, false, elementType, isNullFree || isRequired, null, null);
            }
            return returnType;
        }
    }

    private static class CollectionFlattenHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionFlattenHelper() {
        }

        @Override
        public void resolveUnmodeledTemplateParameterSubstitutions(@NonNull TemplateParameterSubstitutionVisitor templateParameterSubstitutions, @NonNull CallExp callExp) {
            Type elementType = callExp.getOwnedSource().getType();
            while (elementType instanceof CollectionType) {
                elementType = ((CollectionType)elementType).getElementType();
            }
            templateParameterSubstitutions.put(1, elementType);
        }
    }

    private static class CollectionIncludingAllHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionIncludingAllHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type sourceType;
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null && (sourceType = ownedSource.getType()) instanceof CollectionType) {
                Type argumentType;
                OCLExpression ownedArgument;
                CollectionType sourceCollectionType = (CollectionType)sourceType;
                List<OCLExpression> arguments = ((OperationCallExp)callExp).getOwnedArguments();
                if (arguments.size() > 0 && (ownedArgument = arguments.get(0)) != null && (argumentType = ownedArgument.getType()) instanceof CollectionType) {
                    CollectionType argumentCollectionType = (CollectionType)argumentType;
                    boolean isNullFree = sourceCollectionType.isIsNullFree() && argumentCollectionType.isIsNullFree();
                    CollectionType returnCollectionType = (CollectionType)returnType;
                    if (returnCollectionType.isIsNullFree() != isNullFree) {
                        @NonNull Type elementType = returnCollectionType.getElementType();
                        returnType = metamodelManager.getCollectionType(returnCollectionType.isOrdered(), returnCollectionType.isUnique(), elementType, isNullFree, returnCollectionType.getLowerValue(), returnCollectionType.getUpperValue());
                    }
                }
            }
            return returnType;
        }
    }

    private static class CollectionIncludingHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionIncludingHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            Type sourceType;
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null && (sourceType = ownedSource.getType()) instanceof CollectionType) {
                OCLExpression ownedArgument;
                CollectionType sourceCollectionType = (CollectionType)sourceType;
                List<OCLExpression> arguments = ((OperationCallExp)callExp).getOwnedArguments();
                if (arguments.size() > 0 && (ownedArgument = arguments.get(0)) != null) {
                    boolean isNullFree = sourceCollectionType.isIsNullFree() && ownedArgument.isIsRequired();
                    CollectionType returnCollectionType = (CollectionType)returnType;
                    if (returnCollectionType.isIsNullFree() != isNullFree) {
                        @NonNull Type elementType = returnCollectionType.getElementType();
                        returnType = metamodelManager.getCollectionType(returnCollectionType.isOrdered(), returnCollectionType.isUnique(), elementType, isNullFree, returnCollectionType.getLowerValue(), returnCollectionType.getUpperValue());
                    }
                }
            }
            return returnType;
        }
    }

    private static class CollectionSourceElementHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionSourceElementHelper() {
        }

        @Override
        public boolean resolveReturnNullity(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, boolean returnIsRequired) {
            Type sourceType;
            OCLExpression ownedSource = callExp.getOwnedSource();
            if (ownedSource != null && (sourceType = ownedSource.getType()) instanceof CollectionType) {
                returnIsRequired = ((CollectionType)sourceType).isIsNullFree();
            }
            return returnIsRequired;
        }
    }

    private static class CollectionSourceHelper
    extends TemplateParameterSubstitutionHelper {
        private CollectionSourceHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
                Type sourceType = ownedSource.getType();
                CollectionType collectionType = (CollectionType)returnType;
                if (sourceType instanceof CollectionType && ((CollectionType)sourceType).isIsNullFree() && !collectionType.isIsNullFree()) {
                    @NonNull Type elementType = collectionType.getElementType();
                    returnType = metamodelManager.getCollectionType(collectionType.isOrdered(), collectionType.isUnique(), elementType, true, collectionType.getLowerValue(), collectionType.getUpperValue());
                }
            }
            return returnType;
        }

        /* synthetic */ CollectionSourceHelper(CollectionSourceHelper collectionSourceHelper, CollectionSourceHelper collectionSourceHelper2) {
            this();
        }
    }

    private static class OclAnyOclAsSetHelper
    extends TemplateParameterSubstitutionHelper {
        private OclAnyOclAsSetHelper() {
        }

        @Override
        public @Nullable Type resolveReturnType(@NonNull PivotMetamodelManager metamodelManager, @NonNull CallExp callExp, @Nullable Type returnType) {
            OCLExpression ownedSource;
            if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
                CollectionType collectionType = (CollectionType)returnType;
                int collectionBound = ownedSource.isIsRequired() ? 1 : 0;
                IntegerValue lowerBound = ValueUtil.integerValueOf(collectionBound);
                UnlimitedNaturalValue upperBound = ValueUtil.unlimitedNaturalValueOf(collectionBound);
                Type elementType = PivotUtil.getElementType(collectionType);
                returnType = metamodelManager.getCollectionType(collectionType.isOrdered(), collectionType.isUnique(), elementType, true, lowerBound, upperBound);
            }
            return returnType;
        }
    }
}

