/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeCompartmentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public static final String STEREOTYPE_COMPARTMENT_POLICY = "AppliedStereotypeCompartmentEditPolicy";

    public void refreshStereotypeStructure() {
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                this.refreshStereotypeCompartmentStructure(stereotype);
                this.subscribe((EObject)this.helper.getStereotypeCompartment(this.hostView, stereotype));
            }
        }
    }

    protected void refreshStereotypeDisplay() {
    }

    public void removeListener() {
        if (!this.stereotypeList.isEmpty()) {
            for (Stereotype stereotype : this.stereotypeList) {
                BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
                if (compartment == null || stereotype == null) continue;
                this.unsubscribe((EObject)compartment);
                EList properties = stereotype.allAttributes();
                for (Property property : properties) {
                    this.unsubscribe((EObject)this.helper.getStereotypeProperty(this.hostView, stereotype, property));
                }
            }
        }
    }

    protected void refreshStereotypeCompartmentStructure(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostView, stereotype);
        if (compartment == null) {
            this.createAppliedStereotypeCompartment(stereotype);
        }
        this.createAppliedStereotypeProperties(stereotype);
    }

    protected void createAppliedStereotypeCompartment(Stereotype stereotype) {
        View node = this.hostEditPart.getNotationView();
        if (!this.helper.isCompartmentExist(node, stereotype)) {
            this.executeAppliedStereotypeCompartmentCreation(this.hostEditPart, stereotype);
        }
    }

    protected void createAppliedStereotypeProperties(Stereotype stereotype) {
        BasicCompartment compartment = this.helper.getStereotypeCompartment(this.hostEditPart.getNotationView(), stereotype);
        if (compartment != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                this.createAppliedStereotypeProperty((Node)compartment, property);
                this.subscribe((EObject)this.helper.getStereotypeProperty(this.hostView, stereotype, property));
            }
        }
    }

    protected void createAppliedStereotypeProperty(Node compartment, Property property) {
        if (property != null && !property.getName().startsWith("base_") && !this.helper.isPropertyExist((View)compartment, property)) {
            this.executeAppliedStereotypePropertyViewCreation(this.hostEditPart, compartment, property);
        }
    }

    protected void executeAppliedStereotypeCompartmentCreation(IGraphicalEditPart editPart, Stereotype stereotype) {
        CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(editPart.getEditingDomain(), editPart.getNotationView(), stereotype, "StereotypeCompartment");
        this.execute((Command)command);
    }

    protected void executeAppliedStereotypePropertyViewCreation(IGraphicalEditPart editPart, Node compartment, Property stereotypeProperty) {
        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(editPart.getEditingDomain(), (View)compartment, stereotypeProperty, "StereotypeProperty");
        this.execute((Command)command);
    }
}

