/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.LaunchArgs;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ServerLauncher {
    public static final String LOG = "-log";
    public static final String TRACE = "-trace";
    public static final String NO_VALIDATE = "-noValidate";
    @Inject
    private LanguageServerImpl languageServer;

    public static void main(String[] args) {
        String _name = ServerLauncher.class.getName();
        ServerModule _serverModule = new ServerModule();
        ServerLauncher.launch(_name, args, new Module[]{_serverModule});
    }

    public static void launch(String prefix, String[] args, Module ... modules) {
        LaunchArgs launchArgs = ServerLauncher.createLaunchArgs(prefix, args);
        ServerLauncher launcher = (ServerLauncher)Guice.createInjector((Module[])modules).getInstance(ServerLauncher.class);
        launcher.start(launchArgs);
    }

    public void start(LaunchArgs it) {
        try {
            InputOutput.println((Object)"Xtext Language Server is starting.");
            Launcher launcher = Launcher.createLauncher((Object)this.languageServer, LanguageClient.class, (InputStream)it.getIn(), (OutputStream)it.getOut(), (boolean)it.isValidate(), (PrintWriter)it.getTrace());
            this.languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            InputOutput.println((Object)"Xtext Language Server has been started.");
            while (!future.isDone()) {
                Thread.sleep(10000L);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static LaunchArgs createLaunchArgs(String prefix, String[] args) {
        LaunchArgs launchArgs = new LaunchArgs();
        launchArgs.setIn(System.in);
        launchArgs.setOut(System.out);
        ServerLauncher.redirectStandardStreams(prefix, args);
        launchArgs.setTrace(ServerLauncher.getTrace(args));
        launchArgs.setValidate(ServerLauncher.shouldValidate(args));
        return launchArgs;
    }

    public static PrintWriter getTrace(String[] args) {
        boolean _shouldTrace = ServerLauncher.shouldTrace(args);
        if (_shouldTrace) {
            return ServerLauncher.createTrace();
        }
        return null;
    }

    public static PrintWriter createTrace() {
        return new PrintWriter(System.out);
    }

    public static void redirectStandardStreams(String prefix, String[] args) {
        boolean _shouldLogStandardStreams = ServerLauncher.shouldLogStandardStreams(args);
        if (_shouldLogStandardStreams) {
            ServerLauncher.logStandardStreams(prefix);
        } else {
            ServerLauncher.silentStandardStreams();
        }
    }

    public static boolean shouldValidate(String[] args) {
        boolean _testArg = ServerLauncher.testArg(args, NO_VALIDATE);
        return !_testArg;
    }

    public static boolean shouldTrace(String[] args) {
        return ServerLauncher.testArg(args, TRACE);
    }

    public static boolean shouldLogStandardStreams(String[] args) {
        return ServerLauncher.testArg(args, LOG, "debug");
    }

    public static boolean testArg(String[] args, String ... values) {
        Functions.Function1 _function = arg -> ServerLauncher.testArg(arg, values);
        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)args)), (Functions.Function1)_function);
    }

    public static boolean testArg(String arg, String ... values) {
        Functions.Function1 _function = value -> Objects.equal((Object)value, (Object)arg);
        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)values)), (Functions.Function1)_function);
    }

    public static void logStandardStreams(String prefix) {
        try {
            FileOutputStream stdFileOut = new FileOutputStream(prefix + "-debug.log");
            ServerLauncher.redirectStandardStreams(stdFileOut);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void silentStandardStreams() {
        ServerLauncher.redirectStandardStreams(ServerLauncher.silentOut());
    }

    public static void redirectStandardStreams(OutputStream out) {
        ServerLauncher.redirectStandardStreams(ServerLauncher.silentIn(), out);
    }

    public static void redirectStandardStreams(InputStream in, OutputStream out) {
        System.setIn(in);
        PrintStream _printStream = new PrintStream(out);
        System.setOut(_printStream);
    }

    public static OutputStream silentOut() {
        return ByteStreams.nullOutputStream();
    }

    public static InputStream silentIn() {
        byte[] _newByteArrayOfSize = new byte[]{};
        return new ByteArrayInputStream(_newByteArrayOfSize);
    }
}

