/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.CurrentFolderAndPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.DiContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ICurrentFolderAndPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageManagerImpl;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.TransactionalDiContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.TransactionalPageManagerImpl;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;

public class DiSashModelManager {
    protected SashWindowsMngr sashWindowMngr;
    private final PageManagerImpl pageMngr;
    private final DiContentProvider contentProvider;
    private final TransactionalDiContentProvider transDiContentProvider;
    private final IPageModelFactory pageModelFactory;
    protected ContentChangedEventProvider contentChangedEventProvider;

    public DiSashModelManager(IPageModelFactory pageModelFactory, final Resource diResource, TransactionalEditingDomain editingDomain, ICurrentFolderAndPageMngr currentFolderAndPageMngr) {
        this.sashWindowMngr = this.lookupSashWindowMngr(diResource);
        if (this.sashWindowMngr == null) {
            this.sashWindowMngr = this.createDefaultSashModel();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    diResource.getContents().add((Object)DiSashModelManager.this.sashWindowMngr);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
        }
        this.pageModelFactory = pageModelFactory;
        this.contentProvider = new DiContentProvider(this.sashWindowMngr.getSashModel(), pageModelFactory, this.contentChangedEventProvider);
        this.transDiContentProvider = new TransactionalDiContentProvider(this.getDiContentProvider(), editingDomain);
        this.pageMngr = new TransactionalPageManagerImpl(this.sashWindowMngr, this.contentChangedEventProvider, currentFolderAndPageMngr);
    }

    public DiSashModelManager(IPageModelFactory pageModelFactory, final Resource diResource, TransactionalEditingDomain editingDomain) {
        this.sashWindowMngr = this.lookupSashWindowMngr(diResource);
        if (this.sashWindowMngr == null) {
            this.sashWindowMngr = this.createDefaultSashModel();
            try {
                TransactionHelper.run(editingDomain, new Runnable(){

                    @Override
                    public void run() {
                        diResource.getContents().add((Object)DiSashModelManager.this.sashWindowMngr);
                    }
                });
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        this.pageModelFactory = pageModelFactory;
        this.contentProvider = new DiContentProvider(this.sashWindowMngr.getSashModel(), pageModelFactory, this.getContentChangedEventProvider());
        this.transDiContentProvider = new TransactionalDiContentProvider(this.getDiContentProvider(), editingDomain);
        this.pageMngr = new TransactionalPageManagerImpl(this.sashWindowMngr, this.getContentChangedEventProvider());
    }

    public void setCurrentFolderAndPageMngr(ICurrentFolderAndPageMngr currentFolderAndPageMngr) {
        this.pageMngr.setCurrentFolderAndPageMngr(currentFolderAndPageMngr);
    }

    public void setCurrentFolderAndPageMngr(ISashWindowsContainer sashWindowsContainer) {
        this.pageMngr.setCurrentFolderAndPageMngr(new CurrentFolderAndPageManager(sashWindowsContainer));
    }

    protected SashWindowsMngr getDiSashWindowsMngr() {
        return this.sashWindowMngr;
    }

    protected DiContentProvider getDiContentProvider() {
        return this.contentProvider;
    }

    protected TransactionalDiContentProvider getTransactionalDiContentProvider() {
        return this.transDiContentProvider;
    }

    protected final PageManagerImpl getPageManagerImpl() {
        return this.pageMngr;
    }

    protected final ContentChangedEventProvider getContentChangedEventProvider() {
        if (this.contentChangedEventProvider == null) {
            this.contentChangedEventProvider = new ContentChangedEventProvider(this.sashWindowMngr);
        }
        return this.contentChangedEventProvider;
    }

    public IPageManager getIPageManager() {
        return this.getPageManagerImpl();
    }

    public ISashWindowsContentProvider getISashWindowsContentProvider() {
        return this.getTransactionalDiContentProvider();
    }

    public IContentChangedProvider getSashModelContentChangedProvider() {
        return this.getContentChangedEventProvider();
    }

    protected SashWindowsMngr createDefaultSashModel() {
        SashWindowsMngr result = DiUtils.createDefaultSashWindowsMngr();
        if (result.getSashModel() != null) {
            result.getSashModel().setRestoreActivePage(true);
        }
        return result;
    }

    protected SashWindowsMngr lookupSashWindowMngr(Resource diResource) {
        return DiUtils.lookupSashWindowsMngr((Resource)diResource);
    }

    public Map<String, String> getEditorIDsFor(Object pageIdentifier) {
        return this.pageModelFactory.getEditorIDsFor(pageIdentifier);
    }
}

