/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueSelectionWidget;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueWidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MultipleValueDialog
extends SelectionDialog {
    protected MultipleValueWidget widget;

    public MultipleValueDialog(Shell parentShell, IElementSelector selector) {
        this(parentShell, selector, null, false, false);
    }

    public MultipleValueDialog(Shell parentShell, IElementSelector selector, String title) {
        this(parentShell, selector, title, false, false);
    }

    public MultipleValueDialog(Shell parentShell, IElementSelector selector, boolean unique) {
        this(parentShell, selector, null, unique, false);
    }

    public MultipleValueDialog(Shell parentShell, IElementSelector selector, String title, boolean unique, boolean ordered) {
        this(parentShell, selector, title, unique, ordered, -1);
    }

    public MultipleValueDialog(Shell parentShell, IElementSelector selector, String title, boolean unique, boolean ordered, int upperBound) {
        super(parentShell);
        Assert.isNotNull((Object)selector, (String)"The element selector should be defined");
        this.setHelpAvailable(false);
        this.setTitle(title);
        this.widget = this.createWidget(selector, unique, ordered, upperBound);
    }

    protected MultipleValueWidget createWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        return new MultipleValueWidget(selector, unique, ordered, upperBound);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
    }

    public void setInitialElementSelections(List selectedElements) {
        super.setInitialElementSelections(selectedElements);
        this.widget.setInitialSelections(this.getInitialElementSelections());
    }

    public void setInitialSelections(Object[] selectedElements) {
        super.setInitialSelections(selectedElements);
        this.widget.setInitialSelections(this.getInitialElementSelections());
    }

    public void create() {
        super.create();
        this.createDialogContents();
        this.getShell().pack();
        this.widget.updateControls();
    }

    protected void createDialogContents() {
        Composite parent = this.getDialogArea();
        this.widget.create(parent);
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.widget.setFactory(factory);
    }

    protected void okPressed() {
        this.setResult(this.widget.getSelection());
        super.okPressed();
    }

    public void setUnique(boolean unique) {
        this.widget.setUnique(unique);
    }

    public void setOrdered(boolean ordered) {
        this.widget.setOrdered(ordered);
    }

    public void setSelector(IElementSelector selector) {
        this.widget.setSelector(selector);
    }

    public void setUpperBound(int upperBound) {
        this.widget.setUpperBound(upperBound);
    }

    public void setContextElement(Object contextElement) {
        this.widget.setContextElement(contextElement);
    }

    public Object getContextElement() {
        return this.widget.getContextElement();
    }

    public boolean close() {
        if (this.widget != null) {
            this.widget.dispose();
        }
        return super.close();
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.widget.setLabelProvider(labelProvider);
    }

    protected MultipleValueSelectionWidget getWidget() {
        if (this.widget instanceof MultipleValueSelectionWidget) {
            return (MultipleValueSelectionWidget)this.widget;
        }
        return null;
    }
}

