/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateAssociationCommand
extends ConfigureElementCommand {
    private final AggregationKind aggregationKind;

    public CreateAssociationCommand(ConfigureRequest request) {
        this(request, AggregationKind.NONE_LITERAL);
    }

    public CreateAssociationCommand(ConfigureRequest request, AggregationKind aggregationKind) {
        super(request);
        this.aggregationKind = aggregationKind;
    }

    public boolean canExecute() {
        if (this.aggregationKind != null && this.getElementToEdit() instanceof Property) {
            return super.canExecute();
        }
        return false;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Property sourcePart = (Property)this.getElementToEdit();
        if (sourcePart != null) {
            sourcePart.setAggregation(this.aggregationKind);
            if (sourcePart.getType() != null) {
                Type sourceType = (Type)sourcePart.getOwner();
                Package associationContainer = sourceType.getNearestPackage();
                Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                targetProperty.setType(sourceType);
                Association association = UMLFactory.eINSTANCE.createAssociation();
                association.setPackage(associationContainer);
                association.getMemberEnds().add((Object)sourcePart);
                association.getOwnedEnds().add((Object)targetProperty);
                association.getMemberEnds().add((Object)targetProperty);
            }
        }
        return CommandResult.newOKCommandResult((Object)sourcePart);
    }
}

