/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class UMLConnectorUtils
extends ConnectorUtils {
    public static final String NESTED_CONNECTOR_END_PATH = "connectorEndPath";
    public static final String PART_SEPARATOR = ".";
    public static final String HAS_NO_WORD_CHAR_REGEX = "\\W+";
    public static final String STRING_DELIMITER = "'";

    public List<View> getNestedPath(View checkedEnd, View oppositeEnd) {
        List<Object> isNestedConnectableElement = new ArrayList<View>();
        View nearestContainer = new UMLConnectorUtils().getNearestStructureContainer(checkedEnd);
        if (nearestContainer != null) {
            View containerView = new UMLConnectorUtils().deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = new UMLConnectorUtils().getStructureContainers(checkedEnd);
            if (containers.indexOf(nearestContainer) < containers.indexOf(containerView)) {
                isNestedConnectableElement = containers.subList(containers.indexOf(nearestContainer), containers.indexOf(containerView));
            }
        }
        Collections.reverse(isNestedConnectableElement);
        return isNestedConnectableElement;
    }

    public List<Property> getNestedPropertyPath(View checkedEnd, View oppositeEnd) {
        Property partWithPort;
        ArrayList<Property> nestedPropertyPath = new ArrayList<Property>();
        List<View> nestedPath = this.getNestedPath(checkedEnd, oppositeEnd);
        for (View view : nestedPath) {
            if (view.getElement() == null || !(view.getElement() instanceof Property)) continue;
            nestedPropertyPath.add((Property)view.getElement());
        }
        if (!nestedPropertyPath.isEmpty() && checkedEnd.getElement() instanceof Port && (partWithPort = this.getPartWithPort(checkedEnd, oppositeEnd)) != null) {
            nestedPropertyPath.add(partWithPort);
        }
        return nestedPropertyPath;
    }

    public boolean isNestedConnectableElement(View checkedEnd, View oppositeEnd) {
        return !this.getNestedPath(checkedEnd, oppositeEnd).isEmpty();
    }

    public View getNearestStructureContainer(View view) {
        View nearestStructureContainer = null;
        for (View containerView : this.getStructureContainers(view)) {
            if (view == containerView) continue;
            nearestStructureContainer = containerView;
            break;
        }
        return nearestStructureContainer;
    }

    public static final String getNameWithQuotes(NamedElement property) {
        String partName = property.getName();
        StringBuilder partNameBuffer = new StringBuilder();
        Pattern pattern = Pattern.compile(HAS_NO_WORD_CHAR_REGEX);
        Matcher matcher = pattern.matcher(partName);
        boolean mustHaveQuote = false;
        while (matcher.find() && !mustHaveQuote) {
            mustHaveQuote = true;
        }
        if (mustHaveQuote) {
            partNameBuffer.append(STRING_DELIMITER);
            partNameBuffer.append(partName);
            partNameBuffer.append(STRING_DELIMITER);
        } else {
            partNameBuffer.append(partName);
        }
        return partNameBuffer.toString();
    }

    public boolean canDisplayExistingConnectorBetweenViewsAccordingToPartWithPort(Connector connector, View sourceView, View targetView) {
        Property partWithPort = this.getPartWithPortFromConnector(connector);
        if (partWithPort != null) {
            String partWithPortName = partWithPort.getName();
            Type partWithPortType = partWithPort.getType();
            EObject sourceContainer = ((View)sourceView.eContainer()).getElement();
            EObject targetContainer = ((View)targetView.eContainer()).getElement();
            boolean sameSourceType = false;
            if (sourceContainer instanceof TypedElement) {
                sameSourceType = partWithPortType.conformsTo(((TypedElement)sourceContainer).getType());
            }
            boolean sameSourceName = partWithPortName.equals(((NamedElement)sourceContainer).getName());
            boolean sameTargetType = false;
            if (targetContainer instanceof TypedElement) {
                sameTargetType = partWithPortType.conformsTo(((TypedElement)targetContainer).getType());
            }
            boolean sametargetName = partWithPortName.equals(((NamedElement)targetContainer).getName());
            return sameSourceType && sameSourceName || sameTargetType && sametargetName;
        }
        return true;
    }

    public Property getPartWithPortFromConnector(Connector connector) {
        if (connector != null && connector.getEnds() != null) {
            for (ConnectorEnd end : connector.getEnds()) {
                Property partWithPort = end.getPartWithPort();
                if (partWithPort == null) continue;
                return partWithPort;
            }
        }
        return null;
    }

    @Deprecated
    public static boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ConnectableElement)) {
            return false;
        }
        if (target != null && !(target instanceof ConnectableElement)) {
            return false;
        }
        if (sourceView != null && targetView != null) {
            if (sourceView.getChildren().contains((Object)targetView) || targetView.getChildren().contains((Object)sourceView)) {
                return false;
            }
            if (new UMLConnectorUtils().getStructureContainers(sourceView).contains(targetView) || new UMLConnectorUtils().getStructureContainers(targetView).contains(sourceView)) {
                return false;
            }
        }
        return true;
    }
}

