/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2pdf.internal.handler;

import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatus;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.structure2document.internal.handlers.GenerateDocumentFileHandler;
import org.eclipse.papyrus.model2doc.odt.internal.pdf.PDFExporter;
import org.eclipse.papyrus.model2doc.odt.internal.pdf.PDFVersion;

public class GenerateDocumentAndPDFHandler
extends GenerateDocumentFileHandler
implements IExecutableExtension {
    private static final String HANDLER_PARAMETER_ID = "org.eclipse.papyrus.model2doc.odt.emf.structure2pdf.pdfVersion";
    private PDFVersion pdfVersion = PDFVersion.PDF_DEFAULT;

    protected IGenerationStatus generate(IModel2DocLogger logger) {
        IGenerationStatus status = super.generate(logger);
        if (status.isOK() && status.getResult() instanceof String) {
            String generatedDocumentPath = (String)status.getResult();
            PDFExporter exporter = new PDFExporter();
            exporter.setPDFVersion(this.pdfVersion);
            exporter.setOpenEndDialog(false);
            try {
                String result = exporter.exportToPDF(generatedDocumentPath);
                if (result != null) {
                    status = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.odt.emf.structure2pdf", "The pdf creation succeeded.");
                    status.setResult((Object)result);
                    return status;
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.odt.emf.structure2pdf", "The pdf creation failed.", (Throwable)e);
            }
        }
        return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.odt.emf.structure2pdf", "The pdf creation failed with no exception.");
    }

    protected boolean computeEnable(Object evaluationContext) {
        boolean enable = super.computeEnable(evaluationContext);
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            iEvaluationContext.addVariable("pdfVersionMenuLabelId", (Object)this.pdfVersion.getName());
        }
        return enable;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Map && HANDLER_PARAMETER_ID != null) {
            this.pdfVersion = PDFVersion.getPDFVersionByString((String)((String)((Map)data).get(HANDLER_PARAMETER_ID)));
        }
        if (this.pdfVersion == null) {
            this.pdfVersion = PDFVersion.PDF_DEFAULT;
        }
    }
}

