/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class DelegatingToEMFLabelProvider
implements ILabelProvider {
    protected static final String FIELD_LABEL_SEPARATOR = " - ";
    protected static final String MULTI_VALUE_SEPARATOR = ",";
    public static final DelegatingToEMFLabelProvider INSTANCE = new DelegatingToEMFLabelProvider();

    protected DelegatingToEMFLabelProvider() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        IItemLabelProvider lp;
        if (element instanceof EObject && (lp = this.getSubLabelProvider((EObject)element)) != null) {
            Object im = lp.getImage(element);
            if ((im = ExtendedImageRegistry.INSTANCE.getImage(im)) instanceof Image) {
                return (Image)im;
            }
        }
        return null;
    }

    public String getText(Object element) {
        EObject eobject;
        IItemLabelProvider subProvider;
        if (element == null) {
            return "";
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            Iterator iter = ((Collection)element).iterator();
            while (iter.hasNext()) {
                builder.append(this.getText(iter.next()));
                if (!iter.hasNext()) continue;
                builder.append(MULTI_VALUE_SEPARATOR);
                builder.append(" ");
            }
            return builder.toString();
        }
        if (element instanceof EObject && (subProvider = this.getSubLabelProvider(eobject = (EObject)element)) != null) {
            String label = subProvider.getText((Object)eobject);
            if (this.hideEClassNameInTextCalculus()) {
                String eClassName = eobject.eClass().getName();
                StringBuilder eClassBuilderName = new StringBuilder();
                eClassBuilderName.append("<");
                eClassBuilderName.append(eClassName);
                eClassBuilderName.append("> ");
                label = label.replaceAll(eClassBuilderName.toString(), "");
            }
            return label;
        }
        return element.toString();
    }

    protected boolean hideEClassNameInTextCalculus() {
        return true;
    }

    protected final IItemLabelProvider getSubLabelProvider(EObject eobject) {
        AdapterFactory adapterFactory;
        Adapter adapt;
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        ArrayList<Object> types = new ArrayList<Object>();
        types.add(eobject.eClass().getEPackage());
        types.add(IItemLabelProvider.class);
        ComposedAdapterFactory.Descriptor descriptor = registry.getDescriptor(types);
        if (descriptor != null && (adapt = (adapterFactory = descriptor.createAdapterFactory()).adapt((Notifier)eobject, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return (IItemLabelProvider)adapt;
        }
        return null;
    }
}

