/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.core.internal.logger.DefaultModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatusDialogHelper;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureGeneratorWrapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.helpers.DocumentStructureVersionUIHelper;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateDocumentStructureHandler
extends AbstractHandler {
    private DocumentTemplate selectedDocumentTemplate;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DocumentStructureVersionUIHelper versionHelper = new DocumentStructureVersionUIHelper(this.selectedDocumentTemplate);
        Template2StructureGeneratorWrapper wrapper = new Template2StructureGeneratorWrapper(this.selectedDocumentTemplate, versionHelper, (IModel2DocLogger)new DefaultModel2DocLogger(Activator.log));
        IGenerationStatus status = wrapper.generateDocumentStructure();
        GenerationStatusDialogHelper.INSTANCE.openMessageDialog(status);
        return status;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        this.selectedDocumentTemplate = this.getSelectedDocumentTemplate();
        if (this.isEnabled()) {
            this.setBaseEnabled(this.selectedDocumentTemplate != null);
        }
    }

    private DocumentTemplate getSelectedDocumentTemplate() {
        ISelection selection;
        ISelectionService ss;
        IWorkbenchWindow wW;
        Object firstSelectedElement = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wW = wb.getActiveWorkbenchWindow()) != null && (ss = wW.getSelectionService()) != null && (selection = ss.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            firstSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelectedElement instanceof IAdaptable) {
            firstSelectedElement = ((IAdaptable)firstSelectedElement).getAdapter(EObject.class);
        }
        if (firstSelectedElement instanceof DocumentTemplate) {
            return (DocumentTemplate)firstSelectedElement;
        }
        return null;
    }
}

