/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public final class TemplateToStructureMappingService
implements IMappingService {
    private final List<AbstractTemplateToStructureMapper<?>> mappers;

    public TemplateToStructureMappingService(List<AbstractTemplateToStructureMapper<?>> mappers) {
        this.mappers = mappers;
    }

    private AbstractTemplateToStructureMapper<?> getContributorFor(EObject documentTemplateElement, Class<?> expectedReturnedEClass) {
        AbstractTemplateToStructureMapper<?> contributor = null;
        ListIterator<AbstractTemplateToStructureMapper<?>> iter = this.mappers.listIterator();
        while (iter.hasNext() && contributor == null) {
            AbstractTemplateToStructureMapper<?> current = iter.next();
            if (!current.handlesInput(documentTemplateElement) || !current.handlesExpectedOutput(expectedReturnedEClass)) continue;
            contributor = current;
        }
        return contributor;
    }

    @Override
    public <T> List<T> map(EObject documentTemplateElement, EObject semanticModelElement, Class<T> expectedReturnedClass, IModel2DocLogger logger) {
        AbstractTemplateToStructureMapper<?> contributor = this.getContributorFor(documentTemplateElement, expectedReturnedClass);
        List result = null;
        if (contributor != null) {
            result = contributor.map(this, documentTemplateElement, semanticModelElement, expectedReturnedClass, logger);
            if (result == null) {
                result = Collections.emptyList();
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }
}

