/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.template2structure.internal.mappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicRow;
import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesFactory;
import org.eclipse.papyrus.model2doc.core.builtintypes.CellLocation;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextCell;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ExtendedBasicTable;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IColumn;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ITableView;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypePropertyReferenceTableView;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.UMLDocumentStructureTemplatePackage;

public class StereotypePropertyReferenceTableViewMapper
extends AbstractBodyPartTemplateToStructureMapper<StereotypePropertyReferenceTableView> {
    public StereotypePropertyReferenceTableViewMapper() {
        super(UMLDocumentStructureTemplatePackage.eINSTANCE.getStereotypePropertyReferenceTableView(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, StereotypePropertyReferenceTableView stereotypePropertyReferenceTableView, EObject semanticModelElement, Class<T> expectedReturnedClass, IModel2DocLogger logger) {
        ArrayList<T> returnedElements = new ArrayList<T>();
        if (!stereotypePropertyReferenceTableView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        EList rows = stereotypePropertyReferenceTableView.getRows(semanticModelElement);
        EList columns = stereotypePropertyReferenceTableView.getColumns();
        if (rows.isEmpty() || columns.isEmpty()) {
            return null;
        }
        ExtendedBasicTable table = STRUCTURE_EFACTORY.createExtendedBasicTable();
        if (stereotypePropertyReferenceTableView.isGenerateColumnHeader()) {
            BasicRow columnHeader = BuiltInTypesFactory.eINSTANCE.createBasicRow();
            table.getRows().add((Object)columnHeader);
            if (stereotypePropertyReferenceTableView.isGenerateRowHeader()) {
                TextCell cornerCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                cornerCell.setLocation(CellLocation.CORNER);
                columnHeader.getCells().add((Object)cornerCell);
            }
            for (IColumn column : columns) {
                TextCell colHeaderCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                colHeaderCell.setLocation(CellLocation.COLUMN_HEADER);
                colHeaderCell.setText(column.buildColumnHeaderLabel());
                columnHeader.getCells().add((Object)colHeaderCell);
            }
        }
        for (EObject rowElement : rows) {
            BasicRow bodyRow = BuiltInTypesFactory.eINSTANCE.createBasicRow();
            table.getRows().add((Object)bodyRow);
            if (stereotypePropertyReferenceTableView.isGenerateRowHeader()) {
                TextCell rowHeaderCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                rowHeaderCell.setLocation(CellLocation.ROW_HEADER);
                rowHeaderCell.setText(stereotypePropertyReferenceTableView.buildRowHeaderLabel(rowElement));
                bodyRow.getCells().add((Object)rowHeaderCell);
            }
            for (IColumn column : columns) {
                TextCell bodyCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
                bodyCell.setLocation(CellLocation.BODY);
                bodyCell.setText(column.buildCellLabel(column.getCellValue(rowElement)));
                bodyRow.getCells().add((Object)bodyCell);
            }
        }
        if (!this.isEmptyTable(table, (ITableView)stereotypePropertyReferenceTableView)) {
            returnedElements.add(expectedReturnedClass.cast(table));
            returnedElements.add(expectedReturnedClass.cast(STRUCTURE_EFACTORY.createEmptyLine()));
        }
        return this.buildMapperResult((IBodySectionPartTemplate)stereotypePropertyReferenceTableView, semanticModelElement, expectedReturnedClass, returnedElements);
    }

    private boolean isEmptyTable(ExtendedBasicTable table, ITableView tableView) {
        return table.getRowsNumber() == 0 && !tableView.isGenerateColumnHeader() || table.getRowsNumber() == 1 && tableView.isGenerateColumnHeader();
    }
}

