/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.hyperlink;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.internal.ui.dnd.CDOResourceURITransferData;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CreateCDOResourceHyperlinkCommand;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;

public class CDOResourceURIDropStrategy
extends TransactionalDropStrategy {
    private static final String ID = "org.eclipse.papyrus.infra.gmfdiag.commands.cdoResourceURI";

    public String getLabel() {
        return Messages.DropStrategy_label;
    }

    public String getDescription() {
        return Messages.DropStrategy_desc;
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return ID;
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        if (request instanceof DropObjectsRequest) {
            View view = this.getTargetView(targetEditPart);
            if (view == null) {
                return null;
            }
            final View mainView = SemanticElementHelper.findPrimaryView((EObject)view);
            if (mainView instanceof Diagram) {
                return null;
            }
            DropObjectsRequest dropRequest = (DropObjectsRequest)request;
            ArrayList hyperlinkURIs = null;
            for (EObject next : Iterables.filter((Iterable)dropRequest.getObjects(), EObject.class)) {
                if (!CDOResourceURITransferData.isCDOResourceURITransferData((EObject)next)) continue;
                if (hyperlinkURIs == null) {
                    hyperlinkURIs = Lists.newArrayListWithCapacity((int)dropRequest.getObjects().size());
                }
                hyperlinkURIs.addAll(CDOResourceURITransferData.fromEObject((EObject)next).getURIs());
            }
            if (hyperlinkURIs != null) {
                final TransactionalEditingDomain domain = this.getTransactionalEditingDomain(targetEditPart);
                final ArrayList _hyperlinkURIs = hyperlinkURIs;
                return new Command(){

                    public void execute() {
                        for (URI next : _hyperlinkURIs) {
                            new CreateCDOResourceHyperlinkCommand(domain, (EModelElement)mainView, next.lastSegment(), next, false).execute();
                        }
                    }
                };
            }
        }
        return null;
    }
}

