/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dialogs;

import com.google.common.base.Strings;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareModelSet;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.CheckoutBrowseDialog;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.infra.services.controlmode.ui.IControlModeFragmentDialogProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateCDOModelFragmentDialog
extends Dialog {
    private final CDOView view;
    private final URIConverter uriConverter;
    private String selectedURI;
    private Text uriText;
    private Label errorLabel;

    public CreateCDOModelFragmentDialog(Shell parentShell, Resource parentUnit, String defaultUnitName) {
        super(parentShell);
        this.view = ((CDOResource)parentUnit).cdoView();
        this.uriConverter = parentUnit.getResourceSet().getURIConverter();
        URI parentURI = parentUnit.getURI();
        this.selectedURI = parentURI.trimSegments(1).appendSegment(defaultUnitName).appendFileExtension(parentURI.fileExtension()).toString();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_ControlDialog_title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        result.setLayout((Layout)new GridLayout(2, false));
        new Label(result, 0).setText(Messages.CreateCDOFragDlg_uriLabel);
        Composite browseComposite = new Composite(result, 0);
        browseComposite.setLayoutData((Object)new GridData(131072, 128, false, false));
        browseComposite.setLayout((Layout)new RowLayout(256));
        this.createBrowseButtons(browseComposite);
        this.uriText = new Text(result, 2052);
        GridData ld = new GridData(4, 128, true, false, 2, 1);
        ld.widthHint = this.convertWidthInCharsToPixels(50);
        this.uriText.setLayoutData((Object)ld);
        if (this.selectedURI != null) {
            this.uriText.setText(this.selectedURI);
        }
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateCDOModelFragmentDialog.this.validateURI(CreateCDOModelFragmentDialog.this.uriText.getText());
            }
        });
        this.errorLabel = new Label(result, 64);
        this.errorLabel.setLayoutData((Object)new GridData(16384, 128, true, true, 2, 1));
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.selectedURI == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.validateURI(this.selectedURI);
        }
    }

    public URI getSelectedURI() {
        return this.getReturnCode() != 0 || this.selectedURI == null ? null : URI.createURI((String)this.selectedURI, (boolean)true);
    }

    private void createBrowseButtons(Composite composite) {
        Button browseRepo = new Button(composite, 8);
        browseRepo.setText(Messages.CreateCDOFragDlg_browseRepo);
        browseRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateCDOModelFragmentDialog.this.browseRepository();
            }
        });
    }

    private void browseRepository() {
        CheckoutBrowseDialog dlg;
        block4: {
            dlg = new CheckoutBrowseDialog(this.getShell(), Messages.CreateCDOFragDlg_browseTitle, Messages.CreateCDOFragDlg_browseMessage, this.view, 8192);
            dlg.setNodeTypeFilter(EresourcePackage.Literals.CDO_RESOURCE);
            dlg.setAllowOverwrite(false);
            String initialURI = this.uriText.getText().trim();
            if (!Strings.isNullOrEmpty((String)initialURI)) {
                try {
                    dlg.setInitialURI(URI.createURI((String)initialURI, (boolean)true));
                }
                catch (Exception e) {
                    if (this.selectedURI == null) break block4;
                    dlg.setInitialURI(URI.createURI((String)this.selectedURI, (boolean)true));
                }
            }
        }
        if (dlg.open() == 0) {
            this.uriText.setText(dlg.getSelectedURI().toString());
        }
    }

    private void setError(String error) {
        if (error == null) {
            this.errorLabel.setText("");
        } else {
            this.errorLabel.setText(error);
        }
        this.errorLabel.getParent().layout();
    }

    private void validateURI(String uri) {
        if ((uri = uri.trim()).length() == 0) {
            this.getButton(0).setEnabled(false);
        } else {
            try {
                URI parsed = URI.createURI((String)uri, (boolean)true);
                if (parsed.hasFragment()) {
                    throw new IllegalArgumentException(Messages.CreateCDOFragDlg_hasFragmentError);
                }
                if (this.uriConverter.exists(parsed, null)) {
                    throw new IllegalArgumentException(Messages.CreateCDOFragDlg_existsError);
                }
                String folder = CDOURIUtil.extractResourceFolderAndName((URI)parsed)[0];
                if (!Strings.isNullOrEmpty((String)folder)) {
                    if (!this.view.hasResource(folder)) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.CreateCDOFragDlg_noSuchFolderError, (Object)folder));
                    }
                    if (!(this.view.getResourceNode(folder) instanceof CDOResourceFolder)) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.CreateCDOFragDlg_notFolderError, (Object)folder));
                    }
                }
                this.getButton(0).setEnabled(true);
                this.selectedURI = uri;
                this.setError(null);
            }
            catch (Exception e) {
                this.getButton(0).setEnabled(false);
                this.setError(e.getLocalizedMessage());
            }
        }
    }

    public static class AdapterFactory
    implements IAdapterFactory {
        private static final Class<?>[] ADAPTERS = new Class[]{IControlModeFragmentDialogProvider.class};

        public Class[] getAdapterList() {
            return ADAPTERS;
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            Provider result = null;
            if (adapterType == IControlModeFragmentDialogProvider.class && adaptableObject instanceof CDOAwareModelSet) {
                result = new Provider();
            }
            return result;
        }
    }

    public static class Provider
    implements IControlModeFragmentDialogProvider {
        public Dialog createDialog(Shell shell, Resource parentUnit, String defaultUnitURI) {
            return parentUnit instanceof CDOResource ? new CreateCDOModelFragmentDialog(shell, parentUnit, defaultUnitURI) : DEFAULT.createDialog(shell, parentUnit, defaultUnitURI);
        }

        public URI getSelectedURI(Dialog dialog) {
            return dialog instanceof CreateCDOModelFragmentDialog ? ((CreateCDOModelFragmentDialog)dialog).getSelectedURI() : DEFAULT.getSelectedURI(dialog);
        }
    }
}

