/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.markers;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.papyrus.cdo.internal.ui.markers.CDOPapyrusMarker;
import org.eclipse.papyrus.cdo.validation.problems.edit.ProblemEditUtil;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsEvent;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsListener;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsManager;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.markerlistener.providers.AbstractMarkerMonitor;

public class CDOMarkerMonitor
extends AbstractMarkerMonitor {
    private ProblemEditUtil util;
    private ProblemsListener problemsListener;

    public void initialize(ModelSet modelSet) {
        super.initialize(modelSet);
        this.util = new ProblemEditUtil(((AdapterFactoryEditingDomain)modelSet.getTransactionalEditingDomain()).getAdapterFactory());
        this.problemsListener = this.createProblemsListener();
        ProblemsManager.getProblemsManager((ResourceSet)modelSet).addProblemsListener(this.problemsListener);
    }

    public void dispose() {
        if (this.problemsListener != null) {
            ProblemsManager.getProblemsManager((ResourceSet)this.getModelSet()).removeProblemsListener(this.problemsListener);
            this.problemsListener = null;
        }
        super.dispose();
    }

    protected ProblemsListener createProblemsListener() {
        return new ProblemsListener(){

            public void problemAdded(ProblemsEvent event) {
                CDOMarkerMonitor.this.fireMarkerAdded(new CDOPapyrusMarker(event.getProblem(), CDOMarkerMonitor.this.util));
            }

            public void problemRemoved(ProblemsEvent event) {
                CDOMarkerMonitor.this.fireMarkerRemoved(new CDOPapyrusMarker(event.getProblem(), CDOMarkerMonitor.this.util));
            }
        };
    }
}

