/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class CompositeLabelProvider
implements ILabelProvider {
    private List<ILabelProvider> labelProviders = Lists.newArrayList();

    public CompositeLabelProvider() {
    }

    public CompositeLabelProvider(ILabelProvider provider, ILabelProvider ... more) {
        this(Lists.asList((Object)provider, (Object[])more));
    }

    public CompositeLabelProvider(Iterable<? extends ILabelProvider> providers) {
        this();
        Iterables.addAll(this.labelProviders, providers);
    }

    public void addListener(ILabelProviderListener listener) {
        for (ILabelProvider next : this.labelProviders) {
            next.addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        for (ILabelProvider next : this.labelProviders) {
            next.removeListener(listener);
        }
    }

    public void dispose() {
        for (ILabelProvider next : this.labelProviders) {
            next.dispose();
        }
        this.labelProviders.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        for (ILabelProvider next : this.labelProviders) {
            if (!next.isLabelProperty(element, property)) continue;
            return true;
        }
        return false;
    }

    public Image getImage(Object element) {
        Image result = null;
        for (ILabelProvider next : this.labelProviders) {
            result = next.getImage(element);
            if (result != null) break;
        }
        return result;
    }

    public String getText(Object element) {
        String result = null;
        for (ILabelProvider next : this.labelProviders) {
            result = next.getText(element);
            if (result != null) break;
        }
        return result;
    }
}

