/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.cdo.internal.core.CDOProxyResolvingResourceSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.ui.Activator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public class LocalRepositoryView {
    private final Map<CDOCheckout, CDOView> localViews = Maps.newHashMap();
    private ResourceSet rset = null;

    public void dispose() {
        for (Map.Entry<CDOCheckout, CDOView> next : this.localViews.entrySet()) {
            CDOView view = next.getValue();
            try {
                try {
                    CDOUtils.unload((CDOView)view);
                }
                catch (Exception e) {
                    Activator.error("Exception in unloading CDO repository view.", e);
                    view.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                view.close();
                throw throwable;
            }
            view.close();
        }
        this.localViews.clear();
        if (this.rset != null) {
            try {
                try {
                    EMFHelper.unload((ResourceSet)this.rset);
                }
                catch (Exception e) {
                    Activator.error("Exception in unloading CDO repository view's resource set.", e);
                    this.rset = null;
                }
            }
            finally {
                this.rset = null;
            }
        }
    }

    public IStructuredSelection translate(IStructuredSelection selection) {
        return new StructuredSelection(this.translate((EObject)selection.toList()));
    }

    public List<Object> translate(Collection<?> objects) {
        ArrayList result = Lists.newArrayListWithCapacity((int)objects.size());
        for (Object next : objects) {
            if (next instanceof EObject) {
                result.add(this.translate((EObject)next));
                continue;
            }
            if (!(next instanceof DIModel)) continue;
            DIModel di = (DIModel)((Object)next);
            result.add(DIModel.getInstance(this.translate(di.getResource()), true));
        }
        return result;
    }

    public <T extends EObject> T translate(T object) {
        Object result;
        if (object instanceof CDOObject) {
            CDOObject cdo = (CDOObject)object;
            CDOView view = cdo.cdoView();
            if (view == null) {
                result = object;
            } else {
                CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)view);
                CDOView localView = this.localViews.get(checkout);
                if (localView == null) {
                    localView = checkout.openView(true, this.getResourceSet());
                    this.localViews.put(checkout, localView);
                }
                result = localView.getObject(object);
            }
        } else {
            result = object;
        }
        return result;
    }

    protected ResourceSet getResourceSet() {
        if (this.rset == null) {
            this.rset = this.createResourceSet();
        }
        return this.rset;
    }

    protected ResourceSet createResourceSet() {
        return new CDOProxyResolvingResourceSet();
    }
}

