/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.cdo.core.importer.IModelImportMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferMappingListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.ModelTransferListenerAdapter;
import org.eclipse.papyrus.cdo.core.importer.ModelTransferMappingListenerAdapter;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.providers.ModelImportNodeLabelProvider;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelImportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModelMappingsPage
extends ModelImportWizardPage {
    private static final String MESSAGE = Messages.ModelMappingsPage_0;
    private IModelTransferConfiguration importConfig;
    private IModelTransferListener importConfigListener;
    private CDOCheckout checkout;
    private IModelImportMapping manyToOne;
    private IModelTransferMappingListener manyToOneListener;
    private IModelImportMapping oneToOne;
    private IModelTransferMappingListener oneToOneListener;
    private IModelImportMapping selectedMapping;
    private Button manyToOneRadio;
    private Text manyToOnePathText;
    private Button oneToOneRadio;
    private TableViewer oneToOnePathsTable;

    public ModelMappingsPage(EventBus bus) {
        super("mappings", Messages.ModelMappingsPage_2, null, bus, MESSAGE);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        this.manyToOneRadio = new Button(result, 16);
        this.manyToOneRadio.setText(Messages.ModelMappingsPage_3);
        this.manyToOneRadio.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        Label label = new Label(result, 0);
        label.setText(Messages.ModelMappingsPage_4);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().indent(this.convertWidthInCharsToPixels(5), 0).create());
        this.manyToOnePathText = new Text(result, 2048);
        this.manyToOnePathText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.manyToOnePathText.setEnabled(false);
        this.oneToOneRadio = new Button(result, 16);
        this.oneToOneRadio.setText(Messages.ModelMappingsPage_5);
        this.oneToOneRadio.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.oneToOneRadio.setSelection(true);
        this.oneToOnePathsTable = new TableViewer(result);
        this.oneToOnePathsTable.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(this.convertWidthInCharsToPixels(5), 0).create());
        TableViewerColumn column = new TableViewerColumn(this.oneToOnePathsTable, 0);
        column.getColumn().setText(Messages.ModelMappingsPage_6);
        column.getColumn().setWidth(this.convertWidthInCharsToPixels(30));
        column = new TableViewerColumn(this.oneToOnePathsTable, 0);
        column.getColumn().setText(Messages.ModelMappingsPage_7);
        column.getColumn().setWidth(this.convertWidthInCharsToPixels(45));
        column.setEditingSupport((EditingSupport)new OneToOneMappingPathEditingSupport((ColumnViewer)this.oneToOnePathsTable, 1));
        this.oneToOnePathsTable.getTable().setHeaderVisible(true);
        this.oneToOnePathsTable.getTable().setLinesVisible(true);
        this.oneToOnePathsTable.setContentProvider((IContentProvider)new OneToOneMappingContentProvider());
        this.oneToOnePathsTable.setLabelProvider((IBaseLabelProvider)new OneToOneMappingLabelProvider());
        if (this.importConfig != null) {
            this.oneToOnePathsTable.setInput((Object)this.importConfig);
        }
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    if (e.widget == ModelMappingsPage.this.manyToOneRadio) {
                        ModelMappingsPage.this.oneToOneRadio.setSelection(false);
                        ModelMappingsPage.this.oneToOnePathsTable.getControl().setEnabled(false);
                        ModelMappingsPage.this.manyToOnePathText.setEnabled(true);
                    } else {
                        ModelMappingsPage.this.manyToOneRadio.setSelection(false);
                        ModelMappingsPage.this.manyToOnePathText.setEnabled(false);
                        ModelMappingsPage.this.oneToOnePathsTable.getControl().setEnabled(true);
                    }
                    if (e.widget.getData() != null) {
                        ModelMappingsPage.this.selectedMapping((IModelImportMapping)e.widget.getData());
                    }
                    ModelMappingsPage.this.validatePage();
                }
            }
        };
        this.manyToOneRadio.addSelectionListener((SelectionListener)radioListener);
        this.oneToOneRadio.addSelectionListener((SelectionListener)radioListener);
        this.manyToOnePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelMappingsPage.this.manyToOnePathChanged(((Text)e.widget).getText().trim());
            }
        });
        this.setControl((Control)result);
        this.validatePage();
    }

    public void dispose() {
        if (this.importConfig != null) {
            this.importConfig.removeModelTransferListener(this.getImportConfigListener());
        }
        this.importConfig = null;
        super.dispose();
    }

    void selectedMapping(IModelImportMapping mapping) {
        this.selectedMapping = mapping;
        this.post(mapping);
    }

    @Override
    protected Diagnostic doValidatePage() {
        Diagnostic result = Diagnostic.CANCEL_INSTANCE;
        if (this.selectedMapping != null) {
            result = this.selectedMapping.validate();
        }
        return result;
    }

    public IModelImportMapping getSelectedMapping() {
        return this.selectedMapping;
    }

    @Subscribe
    public void setConfiguration(IModelTransferConfiguration config) {
        this.importConfig = config;
        if (config != null) {
            config.addModelTransferListener(this.getImportConfigListener());
        }
        this.setManyToOneMapping(IModelImportMapping.Factory.MANY_TO_ONE.create(config));
        this.setOneToOneMapping(IModelImportMapping.Factory.ONE_TO_ONE.create(config));
        if (this.oneToOnePathsTable != null) {
            this.oneToOnePathsTable.setInput((Object)config);
        }
        this.validatePage();
    }

    private IModelTransferListener getImportConfigListener() {
        if (this.importConfigListener == null) {
            this.importConfigListener = new ModelTransferListenerAdapter(){

                public void modelsToTransferChanged(IModelTransferConfiguration configuration) {
                    if (ModelMappingsPage.this.oneToOnePathsTable != null && !ModelMappingsPage.this.oneToOnePathsTable.getControl().isDisposed()) {
                        ModelMappingsPage.this.oneToOnePathsTable.refresh();
                    }
                }
            };
        }
        return this.importConfigListener;
    }

    private void setManyToOneMapping(IModelImportMapping mapping) {
        if (this.manyToOne != null) {
            this.manyToOne.removeModelTransferMappingListener(this.getManyToOneListener());
        }
        this.manyToOne = mapping;
        if (this.manyToOne != null) {
            this.manyToOne.addModelTransferMappingListener(this.getManyToOneListener());
            this.manyToOne.setCheckout(this.checkout);
            if (this.manyToOneRadio != null) {
                IModelTransferNode node;
                this.manyToOneRadio.setData((Object)this.manyToOne);
                if (this.manyToOneRadio.getSelection()) {
                    this.selectedMapping(this.manyToOne);
                }
                if ((node = (IModelTransferNode)Iterables.getFirst((Iterable)this.importConfig.getModelsToTransfer(), null)) != null) {
                    this.updateManyToOneMapping(node);
                }
            }
        }
    }

    private IModelTransferMappingListener getManyToOneListener() {
        if (this.manyToOneListener == null) {
            this.manyToOneListener = new ModelTransferMappingListenerAdapter(){

                public void modelTransferMappingChanged(IModelTransferNode node) {
                    ModelMappingsPage.this.updateManyToOneMapping(node);
                }
            };
        }
        return this.manyToOneListener;
    }

    void updateManyToOneMapping(IModelTransferNode node) {
        IPath mapping = this.manyToOne.getMapping(node);
        if (mapping != null && this.manyToOnePathText != null) {
            String path = mapping.toString();
            if (!this.manyToOnePathText.getText().equals(path)) {
                this.manyToOnePathText.setText(path);
            }
        }
    }

    private void setOneToOneMapping(IModelImportMapping mapping) {
        if (this.oneToOne != null) {
            this.oneToOne.removeModelTransferMappingListener(this.getOneToOneListener());
        }
        this.oneToOne = mapping;
        if (this.oneToOne != null) {
            this.oneToOne.addModelTransferMappingListener(this.getOneToOneListener());
            this.oneToOne.setCheckout(this.checkout);
            if (this.oneToOneRadio != null) {
                this.oneToOneRadio.setData((Object)this.oneToOne);
                if (this.oneToOneRadio.getSelection()) {
                    this.selectedMapping(this.oneToOne);
                }
            }
        }
    }

    private IModelTransferMappingListener getOneToOneListener() {
        if (this.oneToOneListener == null) {
            this.oneToOneListener = new ModelTransferMappingListenerAdapter(){

                public void modelTransferMappingChanged(IModelTransferNode node) {
                    IPath mapping = ModelMappingsPage.this.oneToOne.getMapping(node);
                    if (mapping != null && ModelMappingsPage.this.oneToOnePathsTable != null) {
                        ModelMappingsPage.this.oneToOnePathsTable.refresh();
                    }
                }
            };
        }
        return this.oneToOneListener;
    }

    @Subscribe
    public void setRepository(CDOCheckout checkout) {
        this.checkout = checkout;
        if (this.manyToOne != null) {
            this.manyToOne.setCheckout(checkout);
        }
        if (this.oneToOne != null) {
            this.oneToOne.setCheckout(checkout);
        }
        this.validatePage();
    }

    private void manyToOnePathChanged(String newPath) {
        try {
            IModelTransferNode node = (IModelTransferNode)Iterables.getFirst((Iterable)this.importConfig.getModelsToTransfer(), null);
            this.setMapping(node, newPath);
        }
        catch (Exception e) {
            this.setMessage(Messages.ModelMappingsPage_8, 3);
        }
    }

    private boolean setMapping(IModelTransferNode node, String newPath) {
        boolean result = false;
        Path path = new Path(newPath);
        if (path.isEmpty()) {
            this.setMessage(Messages.ModelMappingsPage_9, 3);
            this.setPageComplete(false);
        } else if (path.hasTrailingSeparator()) {
            this.setMessage(Messages.ModelMappingsPage_10, 3);
            this.setPageComplete(false);
        } else {
            result = true;
            if (this.selectedMapping != null && node != null) {
                this.selectedMapping.mapTo(node, (IPath)path);
            }
            this.validatePage();
        }
        return result;
    }

    private static class OneToOneMappingContentProvider
    implements IStructuredContentProvider {
        private OneToOneMappingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((IModelTransferConfiguration)inputElement).getModelsToTransfer().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class OneToOneMappingLabelProvider
    extends ModelImportNodeLabelProvider
    implements ITableLabelProvider {
        private OneToOneMappingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(element) : null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = this.getText(element);
                    break;
                }
                case 1: {
                    IPath path;
                    if (ModelMappingsPage.this.oneToOne != null && (path = ModelMappingsPage.this.oneToOne.getMapping((IModelTransferNode)element)) != null) {
                        result = path.toString();
                    }
                    if (result != null) break;
                    result = "";
                }
            }
            return result;
        }
    }

    private class OneToOneMappingPathEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;
        private final int columnIndex;

        OneToOneMappingPathEditingSupport(ColumnViewer columnViewer, int columnIndex) {
            super(columnViewer);
            this.columnIndex = columnIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                this.editor = new TextCellEditor((Composite)this.getViewer().getControl());
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            IPath path = ModelMappingsPage.this.oneToOne.getMapping((IModelTransferNode)element);
            return path == null ? "" : path.toString();
        }

        protected void setValue(final Object element, Object value) {
            String newPath;
            String string = newPath = value == null ? "" : String.valueOf(value);
            if (!ModelMappingsPage.this.setMapping((IModelTransferNode)element, newPath)) {
                this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OneToOneMappingPathEditingSupport.this.getViewer().editElement(element, OneToOneMappingPathEditingSupport.this.columnIndex);
                    }
                });
            }
        }
    }
}

