/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableconfiguration.impl.TableNamedElementImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Table</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getContext <em>Context</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getOwner <em>Owner</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getPrototype <em>Prototype</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getTableConfiguration <em>Table Configuration</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#isInvertAxis <em>Invert Axis</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getColumnAxisProvidersHistory <em>Column Axis Providers History</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getRowAxisProvidersHistory <em>Row Axis Providers History</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getLocalRowHeaderAxisConfiguration <em>Local Row Header Axis Configuration</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getLocalColumnHeaderAxisConfiguration <em>Local Column Header Axis Configuration</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getCurrentRowAxisProvider <em>Current Row Axis Provider</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getCurrentColumnAxisProvider <em>Current Column Axis Provider</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getCells <em>Cells</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getOwnedCellEditorConfigurations <em>Owned Cell Editor Configurations</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.impl.TableImpl#getTableKindId <em>Table Kind Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TableImpl extends TableNamedElementImpl implements Table {

	/**
	 * The default value of the '{@link #isInvertAxis() <em>Invert Axis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #isInvertAxis()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INVERT_AXIS_EDEFAULT = false;

	/**
	 * The default value of the '{@link #getTableKindId() <em>Table Kind Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getTableKindId()
	 * @generated
	 * @ordered
	 */
	protected static final String TABLE_KIND_ID_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TableImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablePackage.Literals.TABLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getContext() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__CONTEXT - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CONTEXT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetContext() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__CONTEXT - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CONTEXT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setContext(EObject newContext) {
		eDynamicSet(NattablePackage.TABLE__CONTEXT - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CONTEXT, newContext);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getOwner() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__OWNER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__OWNER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetOwner() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__OWNER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__OWNER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setOwner(EObject newOwner) {
		eDynamicSet(NattablePackage.TABLE__OWNER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__OWNER, newOwner);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject getPrototype() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__PROTOTYPE - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__PROTOTYPE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EObject basicGetPrototype() {
		return (EObject) eDynamicGet(NattablePackage.TABLE__PROTOTYPE - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__PROTOTYPE, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setPrototype(EObject newPrototype) {
		eDynamicSet(NattablePackage.TABLE__PROTOTYPE - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__PROTOTYPE, newPrototype);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public TableConfiguration getTableConfiguration() {
		return (TableConfiguration) eDynamicGet(NattablePackage.TABLE__TABLE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__TABLE_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public TableConfiguration basicGetTableConfiguration() {
		return (TableConfiguration) eDynamicGet(NattablePackage.TABLE__TABLE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__TABLE_CONFIGURATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setTableConfiguration(TableConfiguration newTableConfiguration) {
		eDynamicSet(NattablePackage.TABLE__TABLE_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__TABLE_CONFIGURATION, newTableConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isInvertAxis() {
		return (Boolean) eDynamicGet(NattablePackage.TABLE__INVERT_AXIS - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__INVERT_AXIS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setInvertAxis(boolean newInvertAxis) {
		eDynamicSet(NattablePackage.TABLE__INVERT_AXIS - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__INVERT_AXIS, newInvertAxis);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<AbstractAxisProvider> getColumnAxisProvidersHistory() {
		return (EList<AbstractAxisProvider>) eDynamicGet(NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<AbstractAxisProvider> getRowAxisProvidersHistory() {
		return (EList<AbstractAxisProvider>) eDynamicGet(NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__ROW_AXIS_PROVIDERS_HISTORY, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public LocalTableHeaderAxisConfiguration getLocalRowHeaderAxisConfiguration() {
		return (LocalTableHeaderAxisConfiguration) eDynamicGet(NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetLocalRowHeaderAxisConfiguration(LocalTableHeaderAxisConfiguration newLocalRowHeaderAxisConfiguration, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newLocalRowHeaderAxisConfiguration, NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLocalRowHeaderAxisConfiguration(LocalTableHeaderAxisConfiguration newLocalRowHeaderAxisConfiguration) {
		eDynamicSet(NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION, newLocalRowHeaderAxisConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public LocalTableHeaderAxisConfiguration getLocalColumnHeaderAxisConfiguration() {
		return (LocalTableHeaderAxisConfiguration) eDynamicGet(NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetLocalColumnHeaderAxisConfiguration(LocalTableHeaderAxisConfiguration newLocalColumnHeaderAxisConfiguration, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newLocalColumnHeaderAxisConfiguration, NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setLocalColumnHeaderAxisConfiguration(LocalTableHeaderAxisConfiguration newLocalColumnHeaderAxisConfiguration) {
		eDynamicSet(NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION, newLocalColumnHeaderAxisConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public AbstractAxisProvider getCurrentRowAxisProvider() {
		return (AbstractAxisProvider) eDynamicGet(NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_ROW_AXIS_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AbstractAxisProvider basicGetCurrentRowAxisProvider() {
		return (AbstractAxisProvider) eDynamicGet(NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_ROW_AXIS_PROVIDER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setCurrentRowAxisProvider(AbstractAxisProvider newCurrentRowAxisProvider) {
		eDynamicSet(NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_ROW_AXIS_PROVIDER, newCurrentRowAxisProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public AbstractAxisProvider getCurrentColumnAxisProvider() {
		return (AbstractAxisProvider) eDynamicGet(NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_COLUMN_AXIS_PROVIDER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AbstractAxisProvider basicGetCurrentColumnAxisProvider() {
		return (AbstractAxisProvider) eDynamicGet(NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_COLUMN_AXIS_PROVIDER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setCurrentColumnAxisProvider(AbstractAxisProvider newCurrentColumnAxisProvider) {
		eDynamicSet(NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CURRENT_COLUMN_AXIS_PROVIDER, newCurrentColumnAxisProvider);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Cell> getCells() {
		return (EList<Cell>) eDynamicGet(NattablePackage.TABLE__CELLS - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__CELLS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ICellEditorConfiguration getOwnedCellEditorConfigurations() {
		return (ICellEditorConfiguration) eDynamicGet(NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetOwnedCellEditorConfigurations(ICellEditorConfiguration newOwnedCellEditorConfigurations, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newOwnedCellEditorConfigurations, NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setOwnedCellEditorConfigurations(ICellEditorConfiguration newOwnedCellEditorConfigurations) {
		eDynamicSet(NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS, newOwnedCellEditorConfigurations);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getTableKindId() {
		return (String) eDynamicGet(NattablePackage.TABLE__TABLE_KIND_ID - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__TABLE_KIND_ID, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void setTableKindId(String newTableKindId) {
		eDynamicSet(NattablePackage.TABLE__TABLE_KIND_ID - ESTATIC_FEATURE_COUNT, NattablePackage.Literals.TABLE__TABLE_KIND_ID, newTableKindId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY:
			return ((InternalEList<?>) getColumnAxisProvidersHistory()).basicRemove(otherEnd, msgs);
		case NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY:
			return ((InternalEList<?>) getRowAxisProvidersHistory()).basicRemove(otherEnd, msgs);
		case NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION:
			return basicSetLocalRowHeaderAxisConfiguration(null, msgs);
		case NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION:
			return basicSetLocalColumnHeaderAxisConfiguration(null, msgs);
		case NattablePackage.TABLE__CELLS:
			return ((InternalEList<?>) getCells()).basicRemove(otherEnd, msgs);
		case NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS:
			return basicSetOwnedCellEditorConfigurations(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablePackage.TABLE__CONTEXT:
			if (resolve) {
				return getContext();
			}
			return basicGetContext();
		case NattablePackage.TABLE__OWNER:
			if (resolve) {
				return getOwner();
			}
			return basicGetOwner();
		case NattablePackage.TABLE__PROTOTYPE:
			if (resolve) {
				return getPrototype();
			}
			return basicGetPrototype();
		case NattablePackage.TABLE__TABLE_CONFIGURATION:
			if (resolve) {
				return getTableConfiguration();
			}
			return basicGetTableConfiguration();
		case NattablePackage.TABLE__INVERT_AXIS:
			return isInvertAxis();
		case NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY:
			return getColumnAxisProvidersHistory();
		case NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY:
			return getRowAxisProvidersHistory();
		case NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION:
			return getLocalRowHeaderAxisConfiguration();
		case NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION:
			return getLocalColumnHeaderAxisConfiguration();
		case NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER:
			if (resolve) {
				return getCurrentRowAxisProvider();
			}
			return basicGetCurrentRowAxisProvider();
		case NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER:
			if (resolve) {
				return getCurrentColumnAxisProvider();
			}
			return basicGetCurrentColumnAxisProvider();
		case NattablePackage.TABLE__CELLS:
			return getCells();
		case NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS:
			return getOwnedCellEditorConfigurations();
		case NattablePackage.TABLE__TABLE_KIND_ID:
			return getTableKindId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablePackage.TABLE__CONTEXT:
			setContext((EObject) newValue);
			return;
		case NattablePackage.TABLE__OWNER:
			setOwner((EObject) newValue);
			return;
		case NattablePackage.TABLE__PROTOTYPE:
			setPrototype((EObject) newValue);
			return;
		case NattablePackage.TABLE__TABLE_CONFIGURATION:
			setTableConfiguration((TableConfiguration) newValue);
			return;
		case NattablePackage.TABLE__INVERT_AXIS:
			setInvertAxis((Boolean) newValue);
			return;
		case NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY:
			getColumnAxisProvidersHistory().clear();
			getColumnAxisProvidersHistory().addAll((Collection<? extends AbstractAxisProvider>) newValue);
			return;
		case NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY:
			getRowAxisProvidersHistory().clear();
			getRowAxisProvidersHistory().addAll((Collection<? extends AbstractAxisProvider>) newValue);
			return;
		case NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION:
			setLocalRowHeaderAxisConfiguration((LocalTableHeaderAxisConfiguration) newValue);
			return;
		case NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION:
			setLocalColumnHeaderAxisConfiguration((LocalTableHeaderAxisConfiguration) newValue);
			return;
		case NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER:
			setCurrentRowAxisProvider((AbstractAxisProvider) newValue);
			return;
		case NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER:
			setCurrentColumnAxisProvider((AbstractAxisProvider) newValue);
			return;
		case NattablePackage.TABLE__CELLS:
			getCells().clear();
			getCells().addAll((Collection<? extends Cell>) newValue);
			return;
		case NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS:
			setOwnedCellEditorConfigurations((ICellEditorConfiguration) newValue);
			return;
		case NattablePackage.TABLE__TABLE_KIND_ID:
			setTableKindId((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablePackage.TABLE__CONTEXT:
			setContext((EObject) null);
			return;
		case NattablePackage.TABLE__OWNER:
			setOwner((EObject) null);
			return;
		case NattablePackage.TABLE__PROTOTYPE:
			setPrototype((EObject) null);
			return;
		case NattablePackage.TABLE__TABLE_CONFIGURATION:
			setTableConfiguration((TableConfiguration) null);
			return;
		case NattablePackage.TABLE__INVERT_AXIS:
			setInvertAxis(INVERT_AXIS_EDEFAULT);
			return;
		case NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY:
			getColumnAxisProvidersHistory().clear();
			return;
		case NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY:
			getRowAxisProvidersHistory().clear();
			return;
		case NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION:
			setLocalRowHeaderAxisConfiguration((LocalTableHeaderAxisConfiguration) null);
			return;
		case NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION:
			setLocalColumnHeaderAxisConfiguration((LocalTableHeaderAxisConfiguration) null);
			return;
		case NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER:
			setCurrentRowAxisProvider((AbstractAxisProvider) null);
			return;
		case NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER:
			setCurrentColumnAxisProvider((AbstractAxisProvider) null);
			return;
		case NattablePackage.TABLE__CELLS:
			getCells().clear();
			return;
		case NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS:
			setOwnedCellEditorConfigurations((ICellEditorConfiguration) null);
			return;
		case NattablePackage.TABLE__TABLE_KIND_ID:
			setTableKindId(TABLE_KIND_ID_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablePackage.TABLE__CONTEXT:
			return basicGetContext() != null;
		case NattablePackage.TABLE__OWNER:
			return basicGetOwner() != null;
		case NattablePackage.TABLE__PROTOTYPE:
			return basicGetPrototype() != null;
		case NattablePackage.TABLE__TABLE_CONFIGURATION:
			return basicGetTableConfiguration() != null;
		case NattablePackage.TABLE__INVERT_AXIS:
			return isInvertAxis() != INVERT_AXIS_EDEFAULT;
		case NattablePackage.TABLE__COLUMN_AXIS_PROVIDERS_HISTORY:
			return !getColumnAxisProvidersHistory().isEmpty();
		case NattablePackage.TABLE__ROW_AXIS_PROVIDERS_HISTORY:
			return !getRowAxisProvidersHistory().isEmpty();
		case NattablePackage.TABLE__LOCAL_ROW_HEADER_AXIS_CONFIGURATION:
			return getLocalRowHeaderAxisConfiguration() != null;
		case NattablePackage.TABLE__LOCAL_COLUMN_HEADER_AXIS_CONFIGURATION:
			return getLocalColumnHeaderAxisConfiguration() != null;
		case NattablePackage.TABLE__CURRENT_ROW_AXIS_PROVIDER:
			return basicGetCurrentRowAxisProvider() != null;
		case NattablePackage.TABLE__CURRENT_COLUMN_AXIS_PROVIDER:
			return basicGetCurrentColumnAxisProvider() != null;
		case NattablePackage.TABLE__CELLS:
			return !getCells().isEmpty();
		case NattablePackage.TABLE__OWNED_CELL_EDITOR_CONFIGURATIONS:
			return getOwnedCellEditorConfigurations() != null;
		case NattablePackage.TABLE__TABLE_KIND_ID:
			return TABLE_KIND_ID_EDEFAULT == null ? getTableKindId() != null : !TABLE_KIND_ID_EDEFAULT.equals(getTableKindId());
		}
		return super.eIsSet(featureID);
	}
} // TableImpl
